% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_degs-methods.R
\name{de_analysis}
\alias{de_analysis}
\title{DE analysis pipeline}
\usage{
de_analysis(
  dge,
  group_col,
  target_group,
  normalize = TRUE,
  group = FALSE,
  filter = c(10, 10),
  plot = FALSE,
  lfc = 0,
  p = 0.05,
  markers = NULL,
  gene_id = "SYMBOL",
  slot = "counts",
  batch = NULL,
  summary = TRUE,
  ...
)
}
\arguments{
\item{dge}{DGEList object for DE analysis, including expr and samples info}

\item{group_col}{character, column name of coldata to specify the DE comparisons}

\item{target_group}{pattern, specify the group of interest, e.g. NK}

\item{normalize}{logical, if the expr in data is raw counts needs to be normalized}

\item{group}{logical, TRUE to separate samples into only 2 groups:
`target_group`` and 'Others'; FALSE to set each level as a group}

\item{filter}{a vector of 2 numbers, filter condition to remove low expression
genes, the 1st for min.counts (if normalize = TRUE) or CPM/TPM
(if normalize = FALSE), the 2nd for samples size 'large.n'}

\item{plot}{logical, if to make plots to show QC before and after filtration}

\item{lfc}{num, cutoff of logFC for DE analysis}

\item{p}{num, cutoff of p value for DE analysis and permutation test if
feature_selection = "rankproduct"}

\item{markers}{vector, a vector of gene names, listed the gene symbols to be
kept anyway after filtration. Default 'NULL' means no special
genes need to be kept.}

\item{gene_id}{character, specify the gene ID target_group of rownames of expression data
when markers is not NULL, could be one of 'ENSEMBL', 'SYMBOL',
'ENTREZ'..., default 'SYMBOL'}

\item{slot}{character, specify which slot to use for DGEList,
default 'counts'}

\item{batch}{vector of character, column name(s) of coldata to be treated as
batch effect factor, default NULL}

\item{summary}{logical, if to show the summary of DE analysis}

\item{...}{omitted}
}
\value{
MArrayLM object generated by \code{\link[limma:ebayes]{limma::treat()}}
}
\description{
Standard DE analysis by using edgeR and limma::voom pipeline
}
\examples{
data("im_data_6")
dge <- edgeR::DGEList(
  counts = Biobase::exprs(im_data_6),
  samples = Biobase::pData(im_data_6)
)
de_analysis(dge, group_col = "celltype.ch1", target_group = "NK")

}
