% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudo_samples-methods.R
\name{pseudo_sample_list}
\alias{pseudo_sample_list}
\title{Split cells according to specific factors}
\usage{
pseudo_sample_list(data, by, min.cells = 0, max.cells = Inf)
}
\arguments{
\item{data}{matrix or data.frame or other single cell expression object}

\item{by}{a vector or data.frame contains factor(s) for aggregation}

\item{min.cells}{num, default 0, the minimum size of cells aggregating
to each pseudo-sample}

\item{max.cells}{num, default Inf, the maximum size of cells aggregating
to each pseudo-sample}
}
\value{
A list of cell names for each pseudo-sample
}
\description{
Gathering cells to make the pool according to specific factors, and randomly
assign the cells from the pool to pseudo-sample with the randomized cell
size. (min.cells <= size <= max.cells)
}
\examples{
counts <- matrix(abs(rnorm(10000, 10, 10)), 100)
rownames(counts) <- 1:100
colnames(counts) <- 1:100
meta <- data.frame(
  subset = rep(c("A", "B"), 50),
  level = rep(1:4, each = 25)
)
rownames(meta) <- 1:100
scRNA <- SeuratObject::CreateSeuratObject(counts = counts, meta.data = meta)
pseudo_sample_list(scRNA,
  by = c("subset", "level"),
  min.cells = 10, max.cells = 20
)
}
