% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterEvents.R
\name{topEvents}
\alias{topEvents}
\title{Filter splicing events based on false discovery rate and PSI change.}
\usage{
topEvents(events, fdr = 0.05, deltaPSI = 0.1)
}
\arguments{
\item{events}{a maser object.}

\item{fdr}{numeric, FDR (False Discovery Rate) cutoff.}

\item{deltaPSI}{numeric, absolute minimum PSI (Percent spliced-in) change}
}
\value{
a maser object.
}
\description{
Filter splicing events based on false discovery rate and PSI change.
}
\examples{
path <- system.file("extdata", file.path("MATS_output"), package = "maser")
hypoxia <- maser(path, c("Hypoxia 0h", "Hypoxia 24h"))

## To select all events with minimum 10\% change in PSI, and FDR < 0.01 
hypoxia_top <- topEvents(hypoxia, fdr = 0.01, deltaPSI = 0.1)
}
