% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappingEvents.R
\name{mapProteinFeaturesToEvents}
\alias{mapProteinFeaturesToEvents}
\title{Mapping of splice events to UniprotKB protein features.}
\usage{
mapProteinFeaturesToEvents(events, tracks, by = c("feature", "category"),
  ncores = 1)
}
\arguments{
\item{events}{a maser object with transcript and protein identifiers.}

\item{tracks}{a character vector indicating valid UniprotKB features or 
categories.}

\item{by}{a character vector, possible values 
are \code{c("feature", "category")}.}

\item{ncores}{number of cores for multithreading (available only in OSX and Linux 
machines). If Windows, \code{ncores} will be set to 1 automatically.}
}
\value{
a maser object with protein feature annotation.
}
\description{
Mapping of splice events to UniprotKB protein features.
}
\details{
This function performs mapping of splicing events to protein
 features available in the UniprotKB database. Annotation tracks of protein
 features mapped to the hg38 build of the human genome are retrieved from the
 public UniprotKB FTP. The function will overlap exons involved in the splice
 event with the feature genomic coordinates retrieved from UniprotKB.

Annotation can be executed either by feature or category. If categories are 
provided, all features within the category group will be included for 
annotation.

Thus, batch annotation is enabled either by using \code{by = category} or 
by providing mutilple features in the \code{tracks} argument.

Visualization of protein features can be done 
using \code{\link{plotUniprotKBFeatures}}.
}
\examples{
## Create the maser object
path <- system.file("extdata", file.path("MATS_output"), package = "maser")
hypoxia <- maser(path, c("Hypoxia 0h", "Hypoxia 24h"))
hypoxia_filt <- filterByCoverage(hypoxia, avg_reads = 5)

## Ensembl GTF annotation for SRSF6
gtf_path <- system.file("extdata", file.path("GTF", "SRSF6_Ensembl85.gtf"),
 package = "maser")
ens_gtf <- rtracklayer::import.gff(gtf_path)

## Retrieve gene specific splice events
srsf6_events <- geneEvents(hypoxia_filt, geneS = "SRSF6")

## Map splicing events to transcripts
srsf6_mapped <- mapTranscriptsToEvents(srsf6_events, ens_gtf)

## Annotate splice events with protein domains
srsf6_annot <- mapProteinFeaturesToEvents(srsf6_mapped, tracks = "domain")
head(annotation(srsf6_annot, "SE"))

}
\seealso{
\code{\link{plotUniprotKBFeatures}}
}
