% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllslotAccessors.R
\docType{methods}
\name{MarrData}
\alias{MarrData}
\alias{MarrData,Marr-method}
\title{Generic function that returns the Marr Data}
\usage{
MarrData(object)

\S4method{MarrData}{Marr}(object)
}
\arguments{
\item{object}{an object of class \code{Marr}.}
}
\value{
Original data object passed to \code{Marr}
}
\description{
Given a Marr object, this function returns the
Marr Data

Accessors for the 'MarrData'
slot of a Marr object.
}
\examples{
data <- matrix(rnorm(2400), nrow=200, ncol=12)
data_Marr <- Marr(object = data, pSamplepairs=0.75,
                  pFeatures=0.75, alpha=0.05)
MarrData(data_Marr)

}
