% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariableAssociation.R
\name{compute_stat_tests}
\alias{compute_stat_tests}
\title{Compute Statistical Tests for Variable Associations with a Target Variable}
\usage{
compute_stat_tests(
  df,
  target_var,
  cols = NULL,
  numeric = "pearson",
  categorical_bin = "t.test",
  categorical_multi = "anova"
)
}
\arguments{
\item{df}{A data frame containing the target variable and predictors.}

\item{target_var}{A string specifying the dependent variable.}

\item{cols}{Optional. A character vector of predictor variables.
If \code{NULL}, all variables except \code{target_var} are used.}

\item{numeric}{The correlation method for numeric predictors.
Options: \code{"pearson"} (default), \code{"spearman"}, \code{"kendall"}.}

\item{categorical_bin}{The statistical test for binary categorical variables.
Options: \code{"t.test"} (default) or \code{"wilcoxon"}.}

\item{categorical_multi}{The statistical test for multi-level categorical
variables.
Options: \code{"anova"} (default) or \code{"kruskal-wallis"}.}
}
\value{
A named list (one entry per variable being analysed) where each
element is a data frame with:
\itemize{
\item \strong{Metric}: The test statistic (correlation coefficient, t-statistic,
ANOVA F-value, etc.).
\item \strong{p-value}: The significance value of the test.
\item For \strong{Categorical Multi}, multiple rows are included for pairwise
comparisons (Tukey HSD results).
}
}
\description{
Performs statistical tests to assess the relationship between predictor
variables
and a target variable, selecting appropriate methods based on variable types.
Returns a list of data frames containing metric values and p-values.
}
\details{
\subsection{\strong{Variable Classification}}{
\itemize{
\item \strong{Numeric}: Continuous numeric or integer variables with more than 10
unique values.
\item \strong{Categorical Bin}: Binary categorical variables (factors, characters, or
integers with exactly 2 unique values).
\item \strong{Categorical Multi}: Categorical variables with more than 2 unique values
(up to 10 levels recommended).
A warning is issued for categorical variables with more than 10 unique
values.
}
}

\subsection{\strong{Statistical Tests Applied}}{
\itemize{
\item \strong{Numeric Predictors}: Pearson, Spearman, or Kendall correlation.
\item \strong{Categorical Bin Predictors}: T-test or Wilcoxon rank-sum test.
\item \strong{Categorical Multi Predictors}: ANOVA (default) or Kruskal-Wallis test.
If ANOVA is used, Tukey's HSD post-hoc test is performed for multiple
comparisons.
}

The function automatically detects variable types and applies the appropriate
test.
If a categorical variable has more than 10 unique levels, a warning is issued.
If an invalid statistical test is requested, the function stops with an error
message.
}
}
\examples{
\dontrun{
df <- data.frame(
  score = c(80, 85, 90, 95, 100),
  age = c(25, 30, 35, 40, 45),
  gender = c("Male", "Female", "Male", "Female", "Male"),
  group = factor(c("A", "B", "A", "B", "C"))
)

results <- compute_stat_tests(df, target_var = "score")
print(results)
}
}
\keyword{internal}
