% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Score_VariableAssociation.R
\name{compute_cohens_f_pval}
\alias{compute_cohens_f_pval}
\title{Compute Cohen's f and p-value for a given model and predictor}
\usage{
compute_cohens_f_pval(model, type)
}
\arguments{
\item{model}{A linear model (\code{lm}) or ANOVA model (\code{aov}) fitted
to the data.}

\item{type}{A string indicating whether the predictor is numeric or
categorical. Options are "Numeric" or "Categorical".}
}
\value{
A named vector with two elements:
\itemize{
\item \code{Cohen_f}: The Cohen's f effect size value.
\item \code{P_Value}: The p-value from the statistical test.
}
}
\description{
This function calculates the Cohen's f effect size and the corresponding
p-value for a given linear model
or ANOVA model based on the predictor variable type (numeric or categorical).
}
\details{
Cohen's f effect size is computed from the eta-squared (\eqn{\eta^2}) value.
For numeric predictors (continuous variables), the p-value is obtained from
the t-test in \code{summary(lm(...))}.
For categorical predictors (binary or multi-level), the p-value is obtained
from the F-test in \code{anova(lm(...))}.
}
\keyword{internal}
