% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Heatmap_Cohen.R
\name{compute_cohen_d}
\alias{compute_cohen_d}
\title{Compute Pairwise Cohen\'s d and P-Values}
\usage{
compute_cohen_d(
  dfScore,
  variable,
  quantitative_var = "score",
  mode = c("simple", "medium", "extensive")
)
}
\arguments{
\item{dfScore}{A data frame containing at least one numeric column and a
grouping variable. Output from flatten_results.}

\item{variable}{A string specifying the name of the categorical grouping
column in \code{dfScore}.}

\item{quantitative_var}{A string specifying the name of the numeric column
(default is \code{"score"}).}
}
\value{
A data frame with the following columns:
\describe{
\item{Group1}{The first group in the pair.}
\item{Group2}{The second group in the pair.}
\item{CohenD}{The computed Cohen\'s d effect size for the comparison.}
\item{PValue}{The p-value from a t-test comparing the two groups.}
}
}
\description{
Computes Cohen\'s d effect sizes and corresponding p-values for all pairwise
comparisons of a grouping variable in a data frame.
}
\keyword{internal}
