% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssGSEA_alternative.R
\name{colRanking}
\alias{colRanking}
\title{Compute Independent Column-wise Ranks of Matrix Elements}
\usage{
colRanking(x, ties.method = "average")
}
\arguments{
\item{x}{A numeric matrix.}

\item{ties.method}{A character string specifying the method used for tie-breaking.
Options include \code{"average"}, \code{"first"}, \code{"random"}, \code{"max"}, or \code{"min"}.
The default is \code{"average"}.}
}
\value{
A numeric matrix of the same dimensions as \code{x} where each column contains the ranks of the corresponding column's elements.
}
\description{
This function computes the rank of each element in every column of a numeric matrix independently.
For each column, the smallest element receives a rank of 1, the second smallest a rank of 2, and so on.
}
\keyword{internal}
