% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalculateScores_ssGSEA.R
\name{CalculateScores_ssGSEA}
\alias{CalculateScores_ssGSEA}
\title{Calculate Gene Signature Scores using ssGSEA}
\usage{
CalculateScores_ssGSEA(data, metadata = NULL, gene_sets)
}
\arguments{
\item{data}{A data frame of normalized (non-transformed) counts where each
row is a gene and each column is a sample.}

\item{metadata}{A data frame containing sample metadata (optional).}

\item{gene_sets}{Gene set input. \strong{(Required)}

If using \strong{unidirectional} gene sets, provide a named list where each
element is a vector of gene names representing a gene signature. The names
of the list elements should correspond to the labels for each signature.

If using \strong{bidirectional} gene sets, provide a named list where each
element is a data frame. The names of the list elements should correspond
to the labels for each signature, and each data frame should contain the
following structure:
\itemize{
\item The \strong{first column} should contain gene names.
\item The \strong{second column} should indicate the expected direction of enrichment
(1 for upregulated genes, -1 for downregulated genes).
}}
}
\value{
A list of data frames containing ssGSEA scores for each signature.
}
\description{
Computes an enrichment score for each gene signature in each sample using the
single-sample Gene Set Enrichment Analysis (ssGSEA).
}
\keyword{internal}
