% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-plotMatrix.R
\name{plotMatrix}
\alias{plotMatrix}
\alias{plotMatrix,DelayedMatrix_OR_matrix-method}
\title{Plot matrix}
\usage{
plotMatrix(
  data,
  params = NULL,
  x = NULL,
  y = NULL,
  width = NULL,
  height = NULL,
  just = c("left", "top"),
  default.units = "inches",
  draw = TRUE,
  palette = colorRampPalette(RColorBrewer::brewer.pal(9, "YlGnBu")),
  zrange = NULL,
  na.color = "grey"
)

\S4method{plotMatrix}{DelayedMatrix_OR_matrix}(
  data,
  params = NULL,
  x = NULL,
  y = NULL,
  width = NULL,
  height = NULL,
  just = c("left", "top"),
  default.units = "inches",
  draw = TRUE,
  palette = colorRampPalette(RColorBrewer::brewer.pal(9, "YlGnBu")),
  zrange = NULL,
  na.color = "grey"
)
}
\arguments{
\item{data}{`DelayedMatrix`, `matrix`, list of matrices,
or 3 column `data.frame` of APA results.}

\item{params}{Optional `pgParams` object
containing relevant function parameters.}

\item{x}{Numeric or unit object specifying
the x-location of plot.}

\item{y}{Numeric or unit object specifying
the y-location of plot.}

\item{width}{Numeric or unit object specifying
the width of plot.}

\item{height}{Numeric or unit object specifying
the height of plot.}

\item{just}{String or numeric vector specifying
the justification of the viewport relative to
its (x, y) location.}

\item{default.units}{String indicating the
default units to use if `x`, `y`, `width`, or
`height` are only given as numeric vectors.}

\item{draw}{Logical value indicating whether
graphics output should be produced.}

\item{palette}{`colorRampPalette` function
to use for mapping values to colors.}

\item{zrange}{Vector of length 2;
max and min values to set color scale}

\item{na.color}{String indicating the color
to use for mapping NA values.}
}
\value{
Function will draw a color-mapped matrix
 and return an S3 object of class `MatrixPlot`.
}
\description{
Used to plot single or aggregate matrix
such as aggregate peak analysis.
}
\examples{

library(plotgardener)
library(RColorBrewer)

## Create divergent matrix ####
m <- matrix(data=rnorm(n=21*21, mean=0, sd=2), nrow=21, ncol=21)

## Define parameters
p <- pgParams(width=3, height=3, default.units="inches")

## Create page
pageCreate(params=p)

## Plot apa
plot <- plotMatrix(data=m,
                   x=p$width/2,
                   y=p$height/2,
                   width=p$width*0.5, height = p$width*0.5,
                   just=c("center", "center"),
                   palette=colorRampPalette(c("blue", "white", "red")),
                   zrange=NULL)

## Annotate legend
annoHeatmapLegend(plot=plot,
                  x=2.3,
                  y=0.75,
                  width=0.1,
                  height=0.75)


## Create sequential matrix
m <- matrix(data=sample(0:100, 21*21, replace=TRUE), nrow=21, ncol=21)

## Define parameters
p <- pgParams(width=3, height=3, default.units="inches")

## Create page
pageCreate(params=p)

## Plot apa
plot <- plotMatrix(data=m,
                   x=p$width/2,
                   y=p$height/2,
                   width=p$width*0.5,
                   height=p$width*0.5,
                   just=c("center", "center"),
                   palette=colorRampPalette(c("white", "dark red")),
                   zrange = NULL)

## Annotate legend
annoHeatmapLegend(plot=plot,
                  x=2.3,
                  y=0.75,
                  width=0.1,
                  height=0.75)

}
