% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-InteractionMatrix.R
\name{path,InteractionMatrix-method}
\alias{path,InteractionMatrix-method}
\alias{path<-,InteractionMatrix-method}
\title{Accessor for h5File path from an InteractionMatrix}
\usage{
\S4method{path}{InteractionMatrix}(object)

\S4method{path}{InteractionMatrix}(object) <- value
}
\arguments{
\item{object}{InteractionMatrix object}

\item{value}{String (length-one character vector)
to use for path replacement.}
}
\value{
The path to the HDF5 file associated with
 the InteractionMatrix object.

Updates path to HDF5 file for the
 InteractionMatrix object.
}
\description{
Returns the file path describing where the on-disk
HDF5 data associated with the InteractionMatrix
object is stored.

This method circumvents the `assays<-`
and `path<-` methods for updating the HDF5
path because they are not accessible when
the file path is broken.
}
\details{
If the file no longer exists, the path is returned
along with a warning.

This allows the file path to be updated even
if the original linked data no longer exists.
}
\examples{
## Load marinerData
if (!require("marinerData", quietly = TRUE))
    BiocManager::install("marinerData")

## Read .hic file paths
hicFiles <- c(
    marinerData::LEUK_HEK_PJA27_inter_30.hic(),
    marinerData::LEUK_HEK_PJA30_inter_30.hic()
)
names(hicFiles) <- c("FS", "WT")

#################################
## Accessing path to HDF5 data ##
#################################

## Create example interactions
x <- read.table(text="
        9 14000000 14500000 9 14500000 15000000
        9 89500000 90000000 9 89500000 90000000
        9 23500000 24000000 9 23500000 24000000")
x <- as_ginteractions(x)

## Extract 3 pixels from 2 hic files
imat <- pullHicPixels(x, hicFiles, 500e03)

## Access path
path(imat)

#################################
## Updating path to HDF5 data ##
################################

## Create example interactions
x <- read.table(text="
        9 14000000 14500000 9 14500000 15000000
        9 89500000 90000000 9 89500000 90000000
        9 23500000 24000000 9 23500000 24000000")
x <- as_ginteractions(x)

## Extract 3 pixels from 2 hic files
h5File <- tempfile(fileext=".h5")
imat <- pullHicPixels(x, hicFiles, 500e03, h5File=h5File)

## Move file to new location
newFile <- tempfile(fileext="_new.h5")
file.rename(from=h5File, to=newFile)

## Update path
path(imat) <- newFile
path(imat)

}
