% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-binRanges.R
\name{binRanges}
\alias{binRanges}
\alias{binRanges,GRanges,numeric,character_OR_numeric_OR_missing-method}
\title{Flexibly bin ranges}
\usage{
binRanges(x, binSize, pos = "center")

\S4method{binRanges}{GRanges,numeric,character_OR_numeric_OR_missing}(x, binSize, pos = "center")
}
\arguments{
\item{x}{`GRanges` object}

\item{binSize}{Integer (numeric) describing
the new size of each range.}

\item{pos}{Position within range
to resize the bin. Can be a character or
integer vector of length 1 or `length(x)`
designating the position for each element
in `x`. Character options are "start", "end"
and "center". Integers are referenced from
the start position for '+' and '*' strands
and from the end position for the '-' strand.}
}
\value{
`GRanges` object that has been shifted
 by `pos` and assigned to bins of `binSize`.
}
\description{
Flexibly bin ranges
}
\examples{
library(GenomicRanges)

## Create example GRanges
gr1 <- GRanges(seqnames = "chr1",
               ranges = IRanges::IRanges(start = rep(5000,3),
                                         end = rep(6000,3)),
               strand = c('+', '-', '*'))

gr2 <- gr1 |> promoters(upstream = 2000, downstream = 200)

## Binning the results
binRanges(x = gr1, binSize = 1000, pos = 'start')
binRanges(x = gr1, binSize = 1000, pos = 'end')
binRanges(x = gr1, binSize = 1000, pos = 'center')

## Bin after shifting back to TSS
binRanges(x = gr2, binSize = 1000, pos = 2000)

}
