% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity.R
\name{sd_similarity}
\alias{sd_similarity}
\title{Calculate Sorensen-Dice similarity between paralogous gene pairs}
\usage{
sd_similarity(edgelist = NULL, paralogs = NULL)
}
\arguments{
\item{edgelist}{A 2-column data frame with regulators in column 1 and
targets in column 2.}

\item{paralogs}{A 2-column data frame with gene IDs for each paralog
in the paralog pair.}
}
\value{
A data frame containing the paralogous gene pairs and their
Sorensen-Dice similarity scores.
}
\description{
Calculate Sorensen-Dice similarity between paralogous gene pairs
}
\examples{
data(gma_ppi)
data(gma_paralogs)
edgelist <- gma_ppi
paralogs <- gma_paralogs
sim <- sd_similarity(edgelist, paralogs)
}
