% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_identification.R
\name{find_bifan}
\alias{find_bifan}
\title{Find bifan motifs}
\usage{
find_bifan(
  edgelist = NULL,
  paralogs = NULL,
  lambda_vec = NULL,
  count_only = FALSE
)
}
\arguments{
\item{edgelist}{A 2-column data frame with regulators in column 1 and
targets in column 2. It can be ignored if you give lambda motifs
to parameter \strong{lambda_vec} (recommended).}

\item{paralogs}{A 2-column data frame with gene IDs for each paralog
in the paralog pair.}

\item{lambda_vec}{A character of lambda motifs as returned
by \code{find_lambda()}. If this is NULL, this function will find lambda
motifs from \strong{edgelist} and \strong{paralogs} first. Passing
previously identified lambda motifs will make this function much faster.}

\item{count_only}{Logical indicating whether the function should return
only motif counts as a numeric scalar. If FALSE, it will return
a character vector of motifs. Default: FALSE.}
}
\value{
A character vector with bifan motifs represented
in the format \strong{regulator1, regulator2->target1, target2}.
}
\description{
Find bifan motifs
}
\examples{
data(gma_grn)
data(gma_paralogs)
edgelist <- gma_grn[1:50000, 1:2]
paralogs <- gma_paralogs[gma_paralogs$type == "WGD", 1:2]
paralogs <- rbind(
paralogs,
data.frame(duplicate1 = "Glyma.01G177200", 
           duplicate2 = "Glyma.08G116700")
)
lambda_vec <- find_lambda(edgelist, paralogs)
bifan <- find_bifan(paralogs = paralogs, lambda_vec = lambda_vec)
}
