% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotStrata.R
\name{plotStrata}
\alias{plotStrata}
\title{An individual plot of power evaulation results by strata.}
\usage{
plotStrata(Power.list, value_option = "FDR")
}
\arguments{
\item{Power.list}{A list produced by \code{\link{powerEval}}.}

\item{value_option}{A character indicating which measurement to plot. Options include "FDR", "FDC", "Power", and "Precision".}
}
\value{
It plots a certain power measurement of the original sequencing depth by strata. Power measurements to plot include "FDR", "FDC", "Power", and "Precision".
}
\description{
This function plots a certain power measurement of the original sequencing depth by strata. Power measurements to plot include "FDR", "FDC", "Power", and "Precision".
}
\examples{

library(magpie)
### Main function
power.test <- quickPower(dataset = "GSE46705", test_method = "TRESS")

### plot a FDR strata result
plotStrata(power.test, value_option = "FDR")

}
