% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrteMafSummary.R
\name{write.mafSummary}
\alias{write.mafSummary}
\title{Writes maf summaries to output tab-delimited text files.}
\usage{
write.mafSummary(maf, basename = NULL, compress = FALSE)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{basename}{basename for output file to be written.}

\item{compress}{If `TRUE` files will be gz compressed. Default `FALSE`}
}
\value{
None. Writes output as text files.
}
\description{
Writes maf summaries to output tab-delimited text files.
}
\details{
Writes MAF and related summaries to output files.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
write.mafSummary(maf = laml, basename = 'laml')

}
\seealso{
\code{\link{read.maf}}
}
