% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/somaticInteractions.R
\name{somaticInteractions}
\alias{somaticInteractions}
\title{Exact tests to detect mutually exclusive, co-occuring and altered genesets.}
\usage{
somaticInteractions(
  maf,
  top = 25,
  genes = NULL,
  pvalue = c(0.05, 0.01),
  returnAll = TRUE,
  geneOrder = NULL,
  fontSize = 0.8,
  leftMar = 4,
  topMar = 4,
  showSigSymbols = TRUE,
  showCounts = FALSE,
  countStats = "all",
  countType = "all",
  countsFontSize = 0.8,
  countsFontColor = "black",
  colPal = "BrBG",
  revPal = FALSE,
  showSum = TRUE,
  plotPadj = FALSE,
  colNC = 9,
  nShiftSymbols = 5,
  sigSymbolsSize = 2,
  sigSymbolsFontSize = 0.9,
  pvSymbols = c(46, 42),
  limitColorBreaks = TRUE
)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{top}{check for interactions among top 'n' number of genes. Defaults to top 25. \code{genes}}

\item{genes}{List of genes among which interactions should be tested. If not provided, test will be performed between top 25 genes.}

\item{pvalue}{Default c(0.05, 0.01) p-value threshold. You can provide two values for upper and lower threshold.}

\item{returnAll}{If TRUE returns test statistics for all pair of tested genes. Default FALSE, returns for only genes below pvalue threshold.}

\item{geneOrder}{Plot the results in given order. Default NULL.}

\item{fontSize}{cex for gene names. Default 0.8}

\item{leftMar}{Left margin. Default 4}

\item{topMar}{Top margin. Default 4}

\item{showSigSymbols}{Default TRUE. Heighlight significant pairs}

\item{showCounts}{Default TRUE. Include number of events in the plot}

\item{countStats}{Default `all`. Can be `all` or `sig`}

\item{countType}{Default `cooccur`. Can be `all`, `cooccur`, `mutexcl`}

\item{countsFontSize}{Default 0.8}

\item{countsFontColor}{Default `black`}

\item{colPal}{colPalBrewer palettes. See RColorBrewer::display.brewer.all() for details}

\item{revPal}{Reverse the color palette. Default FALSE}

\item{showSum}{show [sum] with gene names in plot, Default TRUE}

\item{plotPadj}{Plot adj. p-values instead}

\item{colNC}{Number of different colors in the palette, minimum 3, default 9}

\item{nShiftSymbols}{shift if positive shift SigSymbols by n to the left, default = 5}

\item{sigSymbolsSize}{size of symbols in the matrix and in legend}

\item{sigSymbolsFontSize}{size of font in legends}

\item{pvSymbols}{vector of pch numbers for symbols of p-value for upper and lower thresholds c(upper, lower)}

\item{limitColorBreaks}{limit color to extreme values. Default TRUE}
}
\value{
list of data.tables
}
\description{
Performs Pair-wise Fisher's Exact test to detect mutually exclusive or co-occuring events.
}
\details{
This function and plotting is inspired from genetic interaction analysis performed in the published study combining gene expression and mutation data in MDS. See reference for details.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
somaticInteractions(maf = laml, top = 5)
}
\references{
Gerstung M, Pellagatti A, Malcovati L, et al. Combining gene mutation with gene expression data improves outcome prediction in myelodysplastic syndromes. Nature Communications. 2015;6:5901. doi:10.1038/ncomms6901.
}
