% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPathways2.R
\name{plotPathways}
\alias{plotPathways}
\title{Plot oncogenic pathways}
\usage{
plotPathways(
  maf = NULL,
  pathlist = NULL,
  pathnames = NULL,
  removeNonMutated = FALSE,
  fontSize = 1,
  showTumorSampleBarcodes = FALSE,
  sampleOrder = NULL,
  SampleNamefontSize = 0.6,
  mar = c(4, 6, 2, 3)
)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object}

\item{pathlist}{Output from  \code{\link{pathways}}}

\item{pathnames}{Names of the pathways to be drawn. Default NULL, plots everything from input `pathlist`}

\item{removeNonMutated}{Default FALSE}

\item{fontSize}{Default 1}

\item{showTumorSampleBarcodes}{logical to include sample names.}

\item{sampleOrder}{Manually speify sample names for oncolplot ordering. Default NULL.}

\item{SampleNamefontSize}{font size for sample names. Default 0.6}

\item{mar}{margins Default c(4, 6, 2, 3). Margins to bottom, left, top and right respectively}
}
\description{
Plot oncogenic pathways
}
\details{
Draws pathway burden123
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
p <- pathways(maf = laml)
plotPathways(maf = laml, pathlist = p)
}
\references{
Sanchez-Vega F, Mina M, Armenia J, Chatila WK, Luna A, La KC, Dimitriadoy S, Liu DL, Kantheti HS, Saghafinia S et al. 2018. Oncogenic Signaling Pathways in The Cancer Genome Atlas. Cell 173: 321-337 e310
}
\seealso{
\code{\link{pathways}}
}
