% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtSNPs.R
\name{gtMarkers}
\alias{gtMarkers}
\title{Extract read counts from genetic markers for ASCAT analysis}
\usage{
gtMarkers(
  t_bam = NULL,
  n_bam = NULL,
  build = "hg19",
  prefix = NULL,
  add = TRUE,
  mapq = 10,
  sam_flag = 1024,
  loci = NULL,
  fa = NULL,
  op = NULL,
  zerobased = FALSE,
  nthreads = 4,
  verbose = TRUE
)
}
\arguments{
\item{t_bam}{Tumor BAM file. Required}

\item{n_bam}{Normal BAM file. Recommended}

\item{build}{Default hg19. Mutually exclusive with `loci`. Currently supported `hg19` and `hg38` and includes ca. 900K SNPs from Affymetrix Genome-Wide Human SNP 6.0 Array. SNP file has no `chr` prefix.}

\item{prefix}{Prefix to add or remove from contig names in loci file. For example, in case BAM files have `chr` prefix, set prefix = 'chr'}

\item{add}{If prefix is used, default is to add prefix to contig names in loci file. If false prefix will be removed from contig names.}

\item{mapq}{Minimum mapping quality. Default 10}

\item{sam_flag}{SAM FLAG to filter reads. Default 1024}

\item{loci}{A tab separated file with chr and position. If not available use `build` argument.}

\item{fa}{Indexed fasta file. If provided, extracts and adds reference base to the output tsv.}

\item{op}{Output file basename. Default parses from BAM file}

\item{zerobased}{are coordinates zero-based. Default FALSE. Use only if `loci` is used.}

\item{nthreads}{Number of threads to use. Default 4. Each chromosome will be launched on a separate thread. Works only on Unix and macOS.}

\item{verbose}{Default TRUE}
}
\description{
The function will generate tsv files `<tumor/normal>_nucleotide_counts.tsv` that can be used for downstream analysis. Note that the function will process ~900K loci from Affymetrix Genome-Wide Human SNP 6.0 Array. The process can be sped up by increasing `nthreads` which will launch each chromosome on a separate thread. Currently hg19 and hg38 are supported. Files need to be further processed with \code{\link{prepAscat}} for tumor-normal pair, or \code{\link{prepAscat_t}} for tumor only samples.
}
\seealso{
\code{\link{prepAscat}} \code{\link{prepAscat_t}} \code{\link{segmentLogR}}
}
