% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maf_methods.R
\name{getCytobandSummary}
\alias{getCytobandSummary}
\alias{getCytobandSummary,GISTIC-method}
\title{extract cytoband summary from GISTIC object}
\usage{
getCytobandSummary(x)

\S4method{getCytobandSummary}{GISTIC}(x)
}
\arguments{
\item{x}{An object of class GISTIC}
}
\value{
summarizied gistic results by altered cytobands.
}
\description{
extract cytoband summary from GISTIC object
}
\examples{
all.lesions <- system.file("extdata", "all_lesions.conf_99.txt", package = "maftools")
amp.genes <- system.file("extdata", "amp_genes.conf_99.txt", package = "maftools")
del.genes <- system.file("extdata", "del_genes.conf_99.txt", package = "maftools")
scores.gistic <- system.file("extdata", "scores.gistic", package = "maftools")
laml.gistic = readGistic(gisticAllLesionsFile = all.lesions, gisticAmpGenesFile = amp.genes, gisticDelGenesFile = del.genes, gisticScoresFile = scores.gistic)
getCytobandSummary(laml.gistic)
}
