% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coGisticChromPlotV.R
\name{coGisticChromPlot}
\alias{coGisticChromPlot}
\title{Co-plot version of gisticChromPlot()}
\usage{
coGisticChromPlot(
  gistic1 = NULL,
  gistic2 = NULL,
  g1Name = "",
  g2Name = "",
  type = "Amp",
  markBands = TRUE,
  labelGenes = TRUE,
  gLims = NULL,
  maf1 = NULL,
  maf2 = NULL,
  mutGenes = NULL,
  mutGenes1 = NULL,
  mutGenes2 = NULL,
  fdrCutOff = 0.05,
  symmetric = TRUE,
  color = NULL,
  ref.build = "hg19",
  cytobandOffset = "auto",
  txtSize = 0.8,
  cytobandTxtSize = 1,
  mutGenesTxtSize = 0.6,
  rugTickSize = 0.1
)
}
\arguments{
\item{gistic1}{first \code{GISTIC} object}

\item{gistic2}{second \code{GISTIC} object}

\item{g1Name}{the title of the left side}

\item{g2Name}{the title of the right side}

\item{type}{default 'Amp', c('Amp',"Del"), choose one to plot, only focal events are shown, 'Amp'
only shows the Amplification events, and 'Del' only shows the Deletion events.}

\item{markBands}{default TRUE, integer of length 1 or 2 or TRUE, mark cytoband names of the outer
side of the plot}

\item{labelGenes}{if you want to label some genes you are interested along the chromosome, set it
to TRUE}

\item{gLims}{Controls the G-score's axis limits. Default NULL.}

\item{maf1, maf2}{if labelGenes==TRUE, you need to provide \code{\link{MAF}} object, the genes mutation
info collected from the maf1 is shown on the left side, while maf2 on the right side. the genes
selected are controled by the mutGenes or mutGenes1 or mutGenes1 parameter, see following.}

\item{mutGenes, mutGenes1, mutGenes2}{default NULL, could be NULL, number, or character vector of
gene symbols which match the corresponding  MAF object's Hugo_Symbol column values. mutGenes
controls both sides of the annotation, mutGenes1 controls only left side and corresponding data
is extracted from to maf1, and mutGenes2 controls only right side annotation and corresponding
to maf2. If `NULL`, extract the top 50 mutated genes from maf1 and maf2 seperatedly then
annotate them on the left side (maf1 genes) and right side (maf2 genes). if integer, say N,
only top N genes will be extracted seperately from maf1 and maf2. These two condition leads to
different genes annotated on both sides. If character vector, then the genes have mutated in
maf1 and maf2 will be annotated on both side of the figure which mean the two sides have the
same list of genes. if mutGenes is not NULL and both mutGenes1 and mutGenes1 are NULL, then the
auto set mutGenes1 = mutGenes2 = mutGenes.}

\item{fdrCutOff}{default 0.05,only items with FDR < fdrCutOff will be colored as Amp or Del (
colored 'Red' or 'Blue'), others will be seen as non-significant events (colored gray)}

\item{symmetric}{default TRUE, If False, when the gistic1 and gistic2 have different max values
of G-scores, the Chrom (0 point of x axis) will not be in the center of the whole plot, if you
set symmetric==TRUE, then the one with smaller max(G-score) will be stretched larger to make
the 0 of the x axis in the middle which eventually make the plot more symmetric.}

\item{color}{NULL or a named vector. the color of the G-score lines, default NULL which will set
the color c(Amp = "red", Del = "blue", neutral = 'gray70')}

\item{ref.build}{default "hg19", c('hg18','hg19','hg38') supported at current.}

\item{cytobandOffset}{default 'auto', the width of the chromosome rects (Y axis at 0 point of X
axis). by default will be 0.015 of the width of the whole x axis length.}

\item{txtSize}{the zoom value of most of the texts}

\item{cytobandTxtSize}{textsize of the cytoband annotation}

\item{mutGenesTxtSize}{textsize of the mutGenes annotation}

\item{rugTickSize}{the rug line width of the cytoband annotation}
}
\description{
Use two GISTIC object or/and two MAF objects to view a vertical arranged version of
  Gistic Chromosome plot results on the Amp or Del G-scores.
}
\examples{
\dontrun{
gistic_res_folder = system.file("extdata",package = "maftools")
laml.gistic = readGistic(gistic_res_folder)
laml.gistic2 = readGistic(gistic_res_folder)


laml.maf = system.file('extdata', 'tcga_laml.maf.gz', package = 'maftools')
laml.clin = system.file('extdata', 'tcga_laml_annot.tsv', package = 'maftools')
laml = read.maf(maf = laml.maf, clinicalData = laml.clin)
laml2 = laml

# --- plot ---
gisticChromPlot2v(gistic1 = laml.gistic, gistic2 = laml.gistic2, type='Del',
                   symmetric = TRUE, g1Name = 'TCGA1',
                   g2Name = 'TCGA2', maf1 = laml, maf2 = laml2, mutGenes = 30)
}
}
\author{
bio_sun - https://github.com/biosunsci
}
