% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mCSEAPlotGSEA.R
\name{mCSEAPlotGSEA}
\alias{mCSEAPlotGSEA}
\title{Plot mCSEA results}
\usage{
mCSEAPlotGSEA(rank, mCSEAResults, regionType, dmrName)
}
\arguments{
\item{rank}{A named numeric vector with the ranking statistic of each CpG
site}

\item{mCSEAResults}{The object generated by mCSEATest function}

\item{regionType}{The region type to be represented. Must be one of
"promoters", "genes", "CGI" or "custom"}

\item{dmrName}{The DMR of interest to be represented (e.g. gene name,
CGI name...)}
}
\value{
'NULL'
}
\description{
Generate an enrichment plot
}
\examples{
\dontrun{
library(mCSEAdata)
data(mcseadata)
myRank <- rankProbes(betaTest, phenoTest, refGroup = "Control")
set.seed(123)
myResults <- mCSEATest(myRank, regionsTypes = "promoters",
platform = "EPIC")
}
data(precomputedmCSEA)
mCSEAPlotGSEA(myRank, myResults, "promoters", "CLIC6")
}
\references{
Subramanian, A. et al (2005). \emph{Gene set enrichment analysis:
 A knowledge-based approach for interpreting genome-wide expression profiles}
 . PNAS 102, 15545-15550.
}
\seealso{
\code{\link{rankProbes}}, \code{\link{mCSEATest}},
\code{\link{mCSEAPlot}}
}
\author{
Jordi Martorell Marugán, \email{jordi.martorell@genyo.es}
}
