% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mCSEAIntegrate.R
\name{mCSEAIntegrate}
\alias{mCSEAIntegrate}
\title{Integrate methylation and expression}
\usage{
mCSEAIntegrate(mCSEAResults, exprData, regionType = c("promoters", "genes",
  "CGI", "custom"), geneIDs = "SYMBOL", dmrName = NULL, pcutoff = 0.05,
  minCor = 0.5, minP = 0.05, makePlot = TRUE, folder = ".", nproc = 1)
}
\arguments{
\item{mCSEAResults}{The object generated by mCSEATest function}

\item{exprData}{A matrix or data frame with genes in rows and samples in
columns. A SummarizedExperiment object can be used too}

\item{regionType}{The region types to be represented. Must be one or more of
"promoters", "genes", "CGI" and "custom"}

\item{geneIDs}{Gene identifiers used in exprData. One of "SYMBOL",
"ENSEMBL", "ENTREZID", "GENEID", "REFSEQ" or "UNIGENE"}

\item{dmrName}{The DMR of interest to correlate with expression (e.g. gene
name, CGI name...). If NULL (default), all DMRs with P-Value < pcutoff are
selected}

\item{pcutoff}{P-Value threshold to select DMRs if dmrName = NULL}

\item{minCor}{Correlation threshold to output the results}

\item{minP}{Correlation P-Value threshold to output the results}

\item{makePlot}{If TRUE, generate corelation and save them in the folder
specified by folder parameter}

\item{folder}{Directory to save the correlation plots if makePlot = TRUE}

\item{nproc}{Number of processors to be used}
}
\value{
A data.frame with the integration results.
}
\description{
Uses mCSEA methylation analysis results and expression values to search for
significant correlations between DMRs methylation and close genes expression.
}
\examples{
data(precomputedmCSEA)
data(exprTest)

resultsInt <- mCSEAIntegrate(myResults, exprTest, "promoters", "ENSEMBL",
                            "GATA2", makePlot = FALSE)

resultsInt

}
\seealso{
\code{\link{rankProbes}}, \code{\link{mCSEATest}}
}
\author{
Jordi Martorell Marugán, \email{jordi.martorell@genyo.es}
}
