% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/de-analysis.R
\name{de_analysis}
\alias{de_analysis}
\alias{de_design}
\alias{significant_molecules}
\alias{plot_results_volcano}
\title{Differential analysis of lipids between sample groups}
\usage{
de_analysis(data, ..., measure = "Area", group_col = NULL)

de_design(data, design, ..., coef = NULL, measure = "Area")

significant_molecules(de.results, p.cutoff = 0.05, logFC.cutoff = 1)

plot_results_volcano(de.results, show.labels = TRUE)
}
\arguments{
\item{data}{LipidomicsExperiment object,
should be normalized and log2 transformed.}

\item{...}{Expressions, or character strings which can be parsed to
expressions, specifying contrasts. These are passed to
\code{limma::makeContrasts}.}

\item{measure}{Which measure to use as intensity, usually Area (default).}

\item{group_col}{Name of the column containing sample groups. If not
provided, defaults to first sample annotation column.}

\item{design}{Design matrix generated from \code{\link[=model.matrix]{model.matrix()}},
or a design formula.}

\item{coef}{Column number or column name specifying which coefficient of
the linear model is of interest.}

\item{de.results}{Output of \code{\link[=de_analysis]{de_analysis()}}.}

\item{p.cutoff}{Significance threshold.  Default is \code{0.05}.}

\item{logFC.cutoff}{Cutoff limit for log2 fold change.  Default is \code{1}.
Ignored in multi-group (ANOVA-style) comparisons.}

\item{show.labels}{Whether labels should be displayed for
significant lipids.  Default is \code{TRUE}.}
}
\value{
TopTable as returned by limma package

\code{significant_molecules} returns a character vector with names of
significantly differentially changed lipids.

\code{plot_results_volcano} returns a ggplot object.
}
\description{
\code{de_analysis} and \code{de_design} perform differential analysis of measured
lipids that are associated with a sample group (annotation). \code{de_analysis}
accepts a list of contrasts, while \code{de_design} allows users to define a
design matrix, useful for complex experimental designs or for adjusting
possible confounding variables.
}
\section{Functions}{
\itemize{
\item \code{significant_molecules()}: gets a list of significantly changed lipids for
each contrast.

\item \code{plot_results_volcano()}: plots a volcano chart for differential analysis
results.

}}
\examples{
# type ?normalize_pqn to see how to normalize and log2-transform your data
data(data_normalized)

# Specifying contrasts
de_results <- de_analysis(
  data_normalized,
  HighFat_water - NormalDiet_water,
  measure = "Area"
)
# Using formula
de_results_formula <- de_design(
  data = data_normalized,
  design = ~group,
  coef = "groupHighFat_water",
  measure = "Area"
)

# Using design matrix
design <- model.matrix(~group, data = colData(data_normalized))
de_results_design <- de_design(
  data = data_normalized,
  design = design,
  coef = "groupHighFat_water",
  measure = "Area"
)
significant_molecules(de_results)
plot_results_volcano(de_results, show.labels = FALSE)
}
