% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/visualization.R
\name{plotGenomicRanges}
\alias{plotGenomicRanges}
\alias{plot_genomic_ranges}
\alias{plot_genomic_ranges,linkSet-method}
\title{Plot Genomic Ranges}
\usage{
plotGenomicRanges(
  linkset,
  showBait = NULL,
  showOE = NULL,
  x.range = NULL,
  score.col = "count",
  show.rect = TRUE,
  extend.base = 10000,
  ...,
  bait_col = "red",
  oe_col = "DeepSkyBlue3",
  default_col = "grey",
  vjust = NULL,
  linejoin = "mitre",
  na.rm = FALSE,
  minimal_width = 0.01,
  show.legend = NA,
  inherit.aes = TRUE,
  link_plot_on_top = FALSE,
  arrow.size = 0.05,
  remove_x_axis = FALSE,
  plot.height = 0.4,
  plot.space = 0.1,
  log.scale = TRUE
)

plot_genomic_ranges(
  linkset,
  showBait = NULL,
  showOE = NULL,
  x.range = NULL,
  score.col = "count",
  show.rect = TRUE,
  extend.base = 10000,
  ...,
  bait_col = "red",
  oe_col = "DeepSkyBlue3",
  default_col = "grey",
  vjust = NULL,
  linejoin = "mitre",
  na.rm = FALSE,
  minimal_width = 0.01,
  show.legend = NA,
  inherit.aes = TRUE,
  link_plot_on_top = FALSE,
  arrow.size = 0.05,
  remove_x_axis = FALSE,
  plot.height = 0.4,
  plot.space = 0.1,
  log.scale = TRUE
)

\S4method{plot_genomic_ranges}{linkSet}(
  linkset,
  showBait = NULL,
  showOE = NULL,
  x.range = NULL,
  score.col = "count",
  show.rect = TRUE,
  extend.base = 10000,
  ...,
  bait_col = "red",
  oe_col = "DeepSkyBlue3",
  default_col = "grey",
  vjust = NULL,
  linejoin = "mitre",
  na.rm = FALSE,
  minimal_width = 0.01,
  show.legend = NA,
  inherit.aes = TRUE,
  link_plot_on_top = FALSE,
  arrow.size = 0.05,
  remove_x_axis = FALSE,
  plot.height = 0.4,
  plot.space = 0.1,
  log.scale = TRUE
)
}
\arguments{
\item{linkset}{A linkSet object}

\item{showBait}{Logical indicating whether to show bait regions (default: NULL)}

\item{showOE}{Logical indicating whether to show other end regions (default: NULL)}

\item{x.range}{Range for x-axis (default: NULL)}

\item{score.col}{Column name containing score information (default: "count")}

\item{show.rect}{Whether to show rectangle borders (default: TRUE)}

\item{extend.base}{Base pair extension range (default: 10000)}

\item{...}{Additional plotting parameters}

\item{bait_col}{Color for bait regions (default: "red")}

\item{oe_col}{Color for other end regions (default: "DeepSkyBlue3")}

\item{default_col}{Default color (default: "grey")}

\item{vjust}{Vertical adjustment (default: NULL)}

\item{linejoin}{Line join style (default: "mitre")}

\item{na.rm}{Whether to remove NA values (default: FALSE)}

\item{minimal_width}{Minimal width for plotting (default: 0.01)}

\item{show.legend}{Whether to show legend (default: NA)}

\item{inherit.aes}{Whether to inherit aesthetics (default: TRUE)}

\item{link_plot_on_top}{Whether to plot links on top (default: FALSE)}

\item{arrow.size}{Size of arrow heads (default: 0.05)}

\item{remove_x_axis}{Whether to remove x-axis (default: FALSE)}

\item{plot.height}{Relative height of plot (default: 0.4)}

\item{plot.space}{Plot spacing (default: 0.1)}

\item{log.scale}{Whether to use log scale (default: TRUE)}
}
\value{
A ggplot object
}
\description{
Creates a visualization of genomic ranges and interactions from a linkSet object
}
\details{
Plot Genomic Ranges from linkSet Object
}
\examples{
# Create example linkSet object
library(GenomicRanges)
gr1 <- GRanges(seqnames = c("chr1", "chr1", "chr2"),
               ranges = IRanges(start = c(1000, 2000, 3000), width = 100),
               strand = "+", symbol = c("Gene1", "Gene2", "Gene3"))
gr2 <- GRanges(seqnames = c("chr1", "chr2", "chr2"),
               ranges = IRanges(start = c(5000, 6000, 7000), width = 100),
               strand = "+")
linkset_obj <- linkSet(gr1, gr2, specificCol = "symbol")

# Add count metadata for plotting
mcols(linkset_obj)$count <- c(10, 25, 15)

# Plot genomic ranges (requires annotated bait regions)
\donttest{
# Note: This requires regionsBait to be annotated
# plotGenomicRanges(linkset_obj, extend.base = 1000)
}
}
