% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\docType{class}
\name{linkSet-class}
\alias{linkSet-class}
\alias{LinkSet}
\title{LinkSet object}
\description{
The linkSet object is a container for storing gene-enhancer interactions.
}
\details{
The linkSet object is a vectors of paired gene-enhancer interactions.
}
\section{Slots}{

\describe{
\item{\code{nameBait}}{A character vector of the bait names.}

\item{\code{anchor1}}{A integer vector of the first anchor indices.}

\item{\code{anchor2}}{A integer vector of the second anchor indices.}

\item{\code{regions}}{A GenomicRanges object of the regions.}

\item{\code{NAMES}}{A character vector of the region names.}

\item{\code{elementMetadata}}{A DataFrame of the element metadata.}
}}

\examples{
showClass("linkSet")  # shows the known subclasses

set.seed(7000)
N <- 40
all.starts <- round(runif(N, 1, 100))
all.ends <- all.starts + round(runif(N, 5, 20))
all.regions <- GRanges(rep(c("chrA", "chrB"), c(N-10, 10)), IRanges(all.starts, all.ends))
genes = c(rep("SP7",4),rep("ASPN",10),rep("XBP1",6))
Np <- 20
all.anchor1 <- sample(N, Np)
gr1 <- all.regions[all.anchor1]
gr1$symbol <- genes
all.anchor2 <- setdiff(1:40,all.anchor1)
gr2 <- all.regions[all.anchor2]
x <- linkSet(gr1, gr2,specificCol = "symbol")
x
x2 <- linkSet(genes, gr2)
x2

}
\seealso{
\code{\link{linkSet}}
}
