% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statical.R
\name{verifyLinkSet}
\alias{verifyLinkSet}
\alias{isGlmNbThetaError}
\alias{checkModelNumericalFit}
\alias{multipleTestingCorrect}
\alias{smartSplit}
\alias{verifyInteractionData}
\alias{fitGlm}
\alias{modelRowsSanityCheck}
\alias{isGlmNbMaxiterWarning}
\alias{isGlmNbThetaWarning}
\title{verify.linkSet}
\usage{
verifyLinkSet(linkSet)

isGlmNbThetaError(e)

checkModelNumericalFit(interaction.data)

multipleTestingCorrect(interaction.data, bait.level = TRUE)

smartSplit(dat, bins)

verifyInteractionData(interaction.data)

fitGlm(
  formula,
  data,
  distribution = c("negative-binomial", "poisson", "truncated-poisson",
    "truncated-negative-binomial"),
  start = NULL,
  init.theta = NULL,
  maxit = 100,
  epsilon = 1e-08,
  trace = FALSE
)

modelRowsSanityCheck(model.data, model)

isGlmNbMaxiterWarning(w)

isGlmNbThetaWarning(w)
}
\arguments{
\item{linkSet}{Object to be verified.}

\item{e}{Error object}

\item{interaction.data}{Object to be verified.}

\item{bait.level}{Logical indicating whether multiple testing correction should be performed per bait.}

\item{dat}{Data frame or data table to be split}

\item{bins}{Number of bins to split data into}

\item{formula}{Formula specifying model of interest}

\item{data}{Data frame containing variables specified in formula}

\item{distribution}{Name of distribution of the counts. Options are 'negative-binomial',
'poisson', 'truncated-poisson', and 'truncated-negative-binomial'}

\item{start}{Starting values for model coefficients}

\item{init.theta}{Initial value of theta if fitting the negative binomial distribution}

\item{maxit}{Maximum number of IWLS iterations for fitting the model (passed to \code{glm.control})}

\item{epsilon}{Positive convergence tolerance for Poisson and negative binomial models. Passed to \code{glm.control}}

\item{trace}{Logical indicating if output should be produced for each of model fitting procedure. Passed to \code{glm.control} or \code{gamlss.control}}

\item{model.data}{Data used to fit model}

\item{model}{Resulting negative binomial model object}

\item{w}{Warning object}
}
\value{
None

Boolean indicating if error matches

boolean indicating if model can be fit

Original data table with new column
\item{q.value}{FDR-corrected p-value}

List with \code{bins} elements. Each element corresponds to one portion
of the data

None

List with elements
\item{model}{model object}
\item{expected.values}{vector of expected values for each element in original data}
\item{p.values}{vector of p-values for test of significantly higher response than expected}

None

Logical indicating if warning matches iteration limit reached warning

Boolean indicating if warning matches
}
\description{
Verify that linkSet object is in expected format. Throws an error if object does not fit requirements.

\if{html}{\out{<div class="sourceCode">}}\preformatted{Check if an error matches the error raised by \code{glm.nb} due to an inflated theta estimate.
}\if{html}{\out{</div>}}

This happens when the variance of the negative binomial does not exceed the mean (i.e. there is no overdispersion).
In such cases, the Poisson distribution may be a suitable alternative.

\if{html}{\out{<div class="sourceCode">}}\preformatted{Check if chicane model can be fit on a given dataset. 
}\if{html}{\out{</div>}}

\code{glm.nb} does not work when all responses are constant, or there are only two unique values and a covariate is a perfect predictor.

Perform multiple testing correction on p-values from interaction test.
By default, multiple testing correction is applied per bait. To change this
to a global multiple testing correction, set \code{bait.level = FALSE}.

Split a data frame into a prespecified number of bins, using
\code{split} and \code{cut}. Unlike the default R functions, this does not
fail when asked to split the data into a single bin.

Verify that interaction.data object is in expected format. Throws an error if object does not fit requirements.

Fit GLM according to a specified distribution. This needs to be done separately from \code{glm}
in order to include negative binomial and truncated distributions as options.

\if{html}{\out{<div class="sourceCode">}}\preformatted{Check that the model fit contains the same number of rows as the data used to fit it, 
}\if{html}{\out{</div>}}

and throw an error if not

Check if a warning object is an iteration limit reached warning from \code{glm.nb}

\if{html}{\out{<div class="sourceCode">}}\preformatted{Check if a warning matches the square root warning raised by \code{glm.nb} due to an inflated theta estimate.
}\if{html}{\out{</div>}}

This happens when the variance of the negative binomial does not exceed the mean (i.e. there is no overdispersion).
In such cases, the Poisson distribution may be a suitable alternative.
}
\keyword{internal}
