% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotScatter.R
\name{plotScatter}
\alias{plotScatter}
\title{Scatter plot}
\usage{
plotScatter(
  Y = NULL,
  design = NULL,
  lmpDataList = NULL,
  xy,
  color = NULL,
  shape = NULL,
  points_labs = NULL,
  title = "Scatter plot",
  xlab = NULL,
  ylab = NULL,
  size = 2,
  size_lab = 3,
  drawShapes = c("none", "ellipse", "polygon", "segment"),
  typeEl = c("norm", "t", "euclid"),
  levelEl = 0.9,
  alphaPoly = 0.4,
  theme = theme_bw(),
  drawOrigin = FALSE
)
}
\arguments{
\item{Y}{A \eqn{n \times m} matrix with \eqn{n} observations and \eqn{m} variables. Can be \code{NULL} if \code{lmpDataList} is defined.}

\item{design}{A \eqn{n \times k} "freely encoded" experimental design data.frame. Can be \code{NULL} if \code{lmpDataList} is defined.}

\item{lmpDataList}{If not \code{NULL}, a list with outcomes, design and formula, as outputted by \code{\link{data2LmpDataList}}.}

\item{xy}{x- and y-axis values: a vector of length 2 with either the column name(s) of the \eqn{Y} matrix to plot (character) or the index position(s) (integer).}

\item{color}{If not \code{NULL}, a character string giving the column name of \code{design} to be used as color. Currently treated as a discrete variable.}

\item{shape}{If not \code{NULL}, a character string giving the column name of \code{design} to be used as shape. Currently treated as a discrete variable.}

\item{points_labs}{If not \code{NULL}, a character vector with point labels.}

\item{title}{Plot title.}

\item{xlab}{If not \code{NULL}, label for the x-axis.}

\item{ylab}{If not \code{NULL}, label for the y-axis.}

\item{size}{The points size, by default \code{2}.}

\item{size_lab}{The size of points labels, by default \code{3}.}

\item{drawShapes}{Multiple shapes can be drawn based on the \code{color}: \code{"none"} for no shape (default), \code{"ellipse"} (ellipses with \code{ggplot2::stat_ellipse()}), \code{"polygon"} (polygons with \code{ggplot2::geom_polygon()}) or \code{"segment"} (segment from the centroids with \code{ggplot2::geom_segment()}).}

\item{typeEl}{The type of ellipse, either \code{"norm"} (multivariate normal distribution, the default), \code{"t"} (multivariate t-distribution) or \code{"euclid"} (draws a circle with the radius equal to level, representing the euclidean distance from the center).}

\item{levelEl}{The confidence level at which to draw an ellipse, by default \code{0.9}.}

\item{alphaPoly}{The degree of transparency for polygons, by default \code{0.4}.}

\item{theme}{The \code{ggplot2} theme (default: \code{theme_bw()}), see \code{?ggtheme} for more info.}

\item{drawOrigin}{If \code{TRUE}, draws horizontal and vertical intercepts at (0,0).}
}
\value{
A \code{ggplot2} scatter plot.
}
\description{
Produces a plot describing the relationship between two columns of the outcomes matrix \eqn{Y}. Colors and symbols can be chosen for the levels of the design factors. Ellipses, polygons or segments can be added to group different sets of points on the graph.
}
\details{
Either \code{Y} or \code{lmpDataList} need to be defined. If both are given, the priority goes to \code{Y}.
The same rule applies for \code{design} or \code{lmpDataList}.
}
\examples{

data("UCH")

# Without the design info
plotScatter(Y = UCH$outcomes, xy = c(453, 369))

# equivalent to:
plotScatter(lmpDataList = UCH, xy = c(453, 369))

# With color and shape
plotScatter(
  lmpDataList = UCH,
  xy = c(453, 369), color = "Hippurate",
  shape = "Citrate"
)

# equivalent to:
plotScatter(
  Y = UCH$outcomes, design = UCH$design,
  xy = c(453, 369), color = "Hippurate",
  shape = "Citrate"
)

# With color and shapes
plotScatter(
  Y = UCH$outcomes, design = UCH$design,
  xy = c(453, 369), color = "Hippurate",
  drawShapes = "ellipse"
)

plotScatter(
  Y = UCH$outcomes, design = UCH$design,
  xy = c(453, 369), color = "Hippurate",
  drawShapes = "polygon"
)

plotScatter(
  Y = UCH$outcomes, design = UCH$design,
  xy = c(453, 369), color = "Hippurate",
  drawShapes = "segment"
)

# With customized shapes
library(ggplot2)
plotScatter(
  Y = UCH$outcomes, design = UCH$design,
  xy = c(453, 369), shape = "Hippurate", size = 3
) +
  scale_discrete_identity(
    aesthetics = "shape",
    guide = "legend"
  )

plotScatter(
  Y = UCH$outcomes, design = UCH$design,
  xy = c(453, 369), shape = "Hippurate"
) +
  scale_shape_discrete(solid = FALSE)

plotScatter(
  Y = UCH$outcomes, design = UCH$design,
  xy = c(453, 369), shape = "Hippurate"
) +
  scale_shape_manual(values = c(15, 16, 17))

# With labels
plotScatter(
  Y = UCH$outcomes, design = UCH$design,
  xy = c(453, 369), points_labs = rownames(UCH$design)
)

}
