% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lefserPlotFeat.R
\name{lefserPlotFeat}
\alias{lefserPlotFeat}
\title{Plot Feature}
\usage{
lefserPlotFeat(res, fName, colors = c("c", "l", "g"))
}
\arguments{
\item{res}{An object of class lefser_df,
output of the \code{lefser} function.}

\item{fName}{A character string. The name of a feature in the lefser_df
object.}

\item{colors}{Colors corresponding to class 0 and 1.
Options: "c" (colorblind), "l" (lefse), "g" (greyscale). Defaults to "c".
This argument also accepts a character(2) with two color names.}
}
\value{
A ggplot object.
}
\description{
\code{lefserPlotFeat} plots the abundance data of a DA feature across all
samples.
}
\details{
The solid lines represent the mean by class or by class+subclass
(if the subclass variable is present).
The dashed lines represent the median by class or by class+subclass
(if the subclass variable is present).
}
\examples{

data(zeller14)
zeller14 <- zeller14[, zeller14$study_condition != "adenoma"]
tn <- get_terminal_nodes(rownames(zeller14))
zeller14tn <- zeller14[tn,]
zeller14tn_ra <- relativeAb(zeller14tn)

# (1) Using classes only
res_class <- lefser(zeller14tn_ra,
                    classCol = "study_condition")
# (2) Using classes and sub-classes
res_subclass <- lefser(zeller14tn_ra,
                    classCol = "study_condition",
                    subclassCol = "age_category")
plot_class <- lefserPlotFeat(res_class, res_class$features[[1]])
plot_subclass <- lefserPlotFeat(res_subclass, res_subclass$features[[2]])

}
