% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregateFeatureMethylation.R
\name{dbStats}
\alias{dbStats}
\title{dbStats aggregates methylation of a given betas matrix over specified
database set features}
\usage{
dbStats(
  betas,
  databases,
  fun = mean,
  na.rm = TRUE,
  n_min = NULL,
  f_min = 0.1,
  long = FALSE
)
}
\arguments{
\item{betas}{matrix of beta values where probes are on the rows and
samples are on the columns}

\item{databases}{List of vectors corresponding to probe locations for
which the features will be extracted}

\item{fun}{aggregation function, default to mean}

\item{na.rm}{whether to remove NA}

\item{n_min}{min number of non-NA for aggregation function to apply,
overrides f_min}

\item{f_min}{min fraction of non-NA for aggregation function to apply}

\item{long}{produce long-form result}
}
\value{
matrix with samples on the rows and database set on the columns
}
\description{
dbStats aggregates methylation of a given betas matrix over specified
database set features
}
\examples{
library(SummarizedExperiment)
sesameData::sesameDataCache(data_titles=
c("MM285.467.SE.tissue20Kprobes","KYCG.MM285.probeType.20210630"))
se <- sesameData::sesameDataGet("MM285.467.SE.tissue20Kprobes")
head(dbStats(assay(se), "MM285.probeType")[,1:3])
sesameData::sesameDataGet_resetEnv()

}
