% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmucut.R
\name{km_ucut}
\alias{km_ucut}
\title{Apply user-supplied stratification cutoff}
\usage{
km_ucut(
  obj,
  bfname,
  wdir = getwd(),
  cutoff,
  min_uval = 50,
  psort = FALSE,
  wlabels = TRUE,
  wpdf = TRUE
)
}
\arguments{
\item{obj}{SummarizedExperiment object with expression-like data}

\item{bfname}{a character string (character vector of length 1) that 
specifies the base name used to create output file names, which 
are created by adding\cr"_KM_ucut_.2f" and corresponding extension
to 'bfname'.}

\item{wdir}{a character string (character vector of length 1) that
specifies the name of the working directory for the output files 
(defaults to the current R directory).}

\item{cutoff}{numeric value that specifies the cutoff value for
stratification.The same cutoff is applied to every feature in the dataset.}

\item{min_uval}{numeric value that specifies the minimal percentage of
unique values per feature (default is 50).
Features that have less than 'min_uval' percent unique values are
excluded from the analysis.}

\item{psort}{logical value whether to sort the output table by p-values
in increasing order (default is FALSE).}

\item{wlabels}{logical value whether to write a CSV file with low/high
(below/above the cutoff) group sample labels (default is TRUE).}

\item{wpdf}{logical value whether to write a PDF file with plots
(default is TRUE).}
}
\value{
no return value
}
\description{
For each feature uses the user-supplied cutoff to stratify samples into 2
groups, plots Kaplan-Meier survival curves, and performs the log-rank test.
}
\examples{

# Example with data files included in the package:

# Load example gene expression data and survival data for 2 genes
# and 93 samples
fdat <- system.file("extdata", "example_genes.txt", package = "kmcut")
sdat <- system.file("extdata", "survival_data.txt", package = "kmcut")

# Create SummarizedExperiment object
se <- create_se_object(efile = fdat, sfile = sdat)

# Apply the cutoff of 5
km_ucut(obj = se, bfname = "test", cutoff = 5, min_uval = 90, wpdf = FALSE)

# This will create two output files in the current working directory:
# 1) Tab-delimited text file with the results:
# "test_KM_ucut_5.txt"
# 2) CSV file with low/high sample labels:
# "test_KM_ucut_5_labels.csv"
}
