% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_se_object.R
\name{create_se_object}
\alias{create_se_object}
\title{Create SummarizedExperiment object}
\usage{
create_se_object(efile, sfile, wdir = getwd())
}
\arguments{
\item{efile}{a character string (character vector of length 1) that
specifies the name of the file with expression data 
for each sample. The file must be tab-delimited,
where genes are in rows and samples are in columns. First column must
contain gene names. Column names must contain sample ids.}

\item{sfile}{a character string (character vector of length 1) that
specifies the name of the file with 
right-censored survival time data. The file must be tab-delimited,
where samples are in rows. First column must contain sample ids that match
those in 'efile'. The file must contain columns called 'stime' and 'scens',
with survival time and censoring variable (0 or 1), respectively.}

\item{wdir}{a character string (character vector of length 1) that 
specifies the name of the working directory for the input files 
(defaults to the current R directory).}
}
\value{
a SummarizedExperiment object that contains expression matrix along
with survival data as column data.
}
\description{
Reads a file with expression data and a file with survival data. Then, uses 
the data to create a SummarizedExperiment object.
}
\examples{

# Example with data files included in the package:

# Load example gene expression data and survival data for 2 genes
# and 93 samples:
fdat <- system.file("extdata", "example_genes.txt", package = "kmcut")
sdat <- system.file("extdata", "survival_data.txt", package = "kmcut")

# Create SummarizedExperiment object
se <- create_se_object(efile = fdat, sfile = sdat)
}
