#' MAF file containing genomic variants
#'
#' A dataset that contains the genomic location and other attributes of 191 genomic variants originated from a primary acute promyelocytic leukemia (APL) tumor.
#'
#' @source \url{https://www.bioconductor.org/packages/release/bioc/html/maftools.html}
"APL_primary.maf"

#' VCF file containing genomic variants
#'
#' A dataset that contains the genomic location and other attributes of 3687 genomic variants originated from a primary breast cancer tumor.
#'
#'Mertins P. et al. (2016 ) Proteogenomics connects somatic mutations to signalling in breast cancer . Nature , 534 , 55 –62 .
#'@source \url{https://gdc.cancer.gov/access-data}
"CPTAC_Breast.vcf"

#' A VRanges object containing synthetic genomic variants
#'
#' This VRanges object was constructed using the following function katdetectr::generateSyntheticData(nBackgroundVariants = 500, nKataegisFoci = 1, nKataegisVariants = 20)
#'
"syntheticData.RData"
