% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareParameters2.R
\name{prepareParameters2}
\alias{prepareParameters2}
\title{prepareParameters2}
\usage{
prepareParameters2(function.name, karyoplot, data=NULL, chr=NULL, x=NULL, y=NULL, ymax=NULL, ymin=NULL, r0=NULL, r1=NULL, data.panel=1, filter.data=TRUE, ...)
}
\arguments{
\item{function.name}{(character) The name of the function calling \code{prepareParameters2}. Only user for error reporting.}

\item{karyoplot}{(KaryoPlot) A karyoplot object.}

\item{data}{A GRanges. It can be NULL or a GRanges.}

\item{chr}{A character representing the chromosome names.}

\item{x}{The position in the chromosome in number of bases.}

\item{y}{The value to be plotted.}

\item{ymax}{The maximum value of y}

\item{ymin}{The minimum value of y}

\item{r0}{The start of the range to use for plotting}

\item{r1}{The end of the range to use for plotting}

\item{data.panel}{The data panel to use}

\item{filter.data}{A boolean indicating if data should be filtered so only data in visible chromosomes is kept. (defaults to TRUE, filter data)}

\item{...}{Any additional parameter}
}
\value{
A list with three values: \code{chr}, \code{x} and \code{y}. Each of them 
a vector of the same length with the normalized values to plot.
}
\description{
Prepare and normalize the parameters for functions with x and y parameters
}
\details{
This function prepares and normalizes the parameters for plotting functions  
with x and y parameters (as opposed to x0, x1, y0 and y1) so functions can
offer a richer interface while internally dealing only with standard and 
simple code. It extracts the 
positions from \code{data} if available and applies the \code{r0} and 
\code{r1} scaling. It returns the ready to plot values in a list with
only \code{chr}, \code{x} and \code{y}. Individual parameters (\code{chr},
\code{x} and \code{y}) take precedence over \code{data}. All parameters are 
interpreted and used as explained in \code{\link{kpPoints}}. It also filters
out any data points corresponding to chromosomes not present in the current 
karyoplot.
}
\note{
This function is only useful when creating custom plotting functions. 
It is not intended to the general user.

For detailed documentation on the parameters, see \code{\link{kpPoints}}
}
\examples{

kp <- plotKaryotype()
prepareParameters2("TestFunc", kp, data=NULL, chr="chr1", x=c(10, 20, 30), y=c(0, 1, 2), r0=0, r1=0.5, ymin=0, ymax=2)

 
}
\seealso{
\code{\link{kpPoints}}
}
