% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color.R
\name{plotPalettes}
\alias{plotPalettes}
\title{plotPalette}
\usage{
plotPalettes(cols, add.color.name=TRUE, border=NA, palette.names.col="black", palette.names.cex=1, palette.names.srt=0, color.names.col="auto", color.names.cex=1, color.names.srt=0, ...)
}
\arguments{
\item{cols}{(color vector or list of color vectors) The colors to plot}

\item{add.color.name}{(logical) Wether to add or not the names of the colors, their definition.}

\item{border}{(color) The color of the border of the palette rectangles. If NA, no border. (defaults to NA)}

\item{palette.names.col}{(color) The color of the palette names (defaults to "black")}

\item{palette.names.cex}{(numeric) The cex value (size) for the palette names (defaults to 1)}

\item{palette.names.srt}{(numeric) The srt value (rotation) for the palette names (defaults to 0)}

\item{color.names.col}{(color) The color of the color names. If auto, it will be blak for light colors and white for the dark ones (defaults to "auto")}

\item{color.names.cex}{(numeric) The cex value (size) for the color names  (defaults to 1)}

\item{color.names.srt}{(numeric) The srt value (rotation) for the color names (defaults to 0)}

\item{...}{Any additional plotting parameters}
}
\value{
nothing
}
\description{
Create a plot of the palette.
}
\details{
Creates a simple plot with a rectangle for every color of every palette.
cols must be either a vector of colors (in any format accepted by 
karyoploteR::"is.color") or a list of such vectors.
The names of the list elements will be treated as the palette names, if
the list has no names, palettes will be called "Pallete1", "Palette2", ...
}
\examples{
 
plotPalettes(c("red", "blue", "yellow", "green"))
palettes <- list("P1"=c("red", "#000000", lighter("gold")), 
                 "P2"=c("orchid", "yellow"))
plotPalettes(palettes, color.names.col=c("blue", "green", "red"), border="black", color.names.srt=45)
plotPalettes(palettes, color.names.col="auto", border="black", color.names.srt=45)

}
