% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotKaryotype.R
\name{plotKaryotype}
\alias{plotKaryotype}
\title{plotKaryotype}
\usage{
plotKaryotype(genome="hg19", plot.type=1, ideogram.plotter=kpAddCytobands, labels.plotter=kpAddChromosomeNames, chromosomes="auto", zoom=NULL, cytobands=NULL, plot.params=NULL, use.cache=TRUE, main=NULL, ...)
}
\arguments{
\item{genome}{The genome to plot. It can be either a UCSC style genome name (hg19, mm10, etc), a BSgenome, a Seqinfo object, a GRanges object with the chromosomes as ranges or in general any genome specification accepted by \code{\link[regioneR]{getGenomeAndMask}}. (defaults to "hg19")}

\item{plot.type}{The orientation of the ideogram and placing of the data panels. Values explained above.. (defaults to 1)}

\item{ideogram.plotter}{The function to be used to plot the ideograms. Only one function is included with the package, \code{kpAddCytobands}, but it is possible to create custom ones. If NULL, no ideograms are plotted. (defaults to \code{kpAddCytobands})}

\item{labels.plotter}{The function to be used to plot the labels identifying the chromosomes. Only one function is included with the package, \code{kpAddChromosomeNames}, but it is possible to create custom ones. If NULL, no labels are plotted. (defaults to \code{kpAddChromosomeNames})}

\item{chromosomes}{The chromosomes to plot. Can be either a vector of chromosome names or a chromosome group name ("canonical", "autosomal", "all"). Setting it yo "auto" will select canonical. If no predefined filtering data is available, a heuristic filtering  will be used. To deactivate filtering set chromosomes="all". (defaults to "auto")}

\item{zoom}{A GRanges object specifiyng a single region to zoom in or any format accepted by \code{regioneR::toGRanges}. If not NULL, it takes precedence over \code{chromosome} and only the zoomed in region is represented. If more than one region is present in the GRanges, only the first one is used. (defaults to NULL, do not zoom in and show the whole plot as specified by \code{genome} and \code{chromosomes})}

\item{cytobands}{A GRanges object (or anything accepted by \code{\link[regioneR]{toGRanges}} function: bed file, data.frame...) specifying the positions and types of the cytobands. The type of the cytobands MUST be in a column named "gieStain" (as used by UCSC) with values such as 'gneg', 'gpos50', 'stalk', 'acen'... If NULL, the cytobands are recovered from the package cache or downloaded from UCSC if possible (it's not possible for custom genomes). If empty, no cytobands will be plotted. (defaults to NULL)}

\item{plot.params}{An object obtained from \code{\link{getDefaultPlotParams}} and possibly modified, containing the basic plotting parameters. If NULL, the defaults parameters will be used. (defaults to NULL)}

\item{use.cache}{\code{karyoploteR} has a small cache with the chromosome names and lengths and the cytobands for a handful of organisms so it's not needed to retrieve them from databses or \code{BSGenomes} objects. Set this parameter to FALSE to ignore the cache. (defaults to TRUE, use the cache)}

\item{main}{The text to be used as the title of the plot. NULL produces no title. (defaults to NULL)}

\item{...}{The ellipsis can be used to pass in any additional parameter accepted by the internal functions used.}
}
\value{
The \code{KaryoPlot} object needed by the plotting functions.
}
\description{
Create a new empty plot with a karyotype (the chromosome ideograms and chromosome names).
}
\details{
This is the main function of \code{karyoploteR}. It creates the basic empty plot with 
 the chromosome ideograms and returns the karyoplot object needed for all other plotting 
 functions. Both the basic plotting parameters (margins, sizes, etc.) and the specific
 plotting functions for the ideograms and chromosome labels are customizable. 
 In particular, passing in a \code{plot.params} object specifies the basic plotting 
 parameters to use and the \code{ideogram.plotter} and \code{labels.plotter} parameters 
 can be used to specify custom plotting functions for the ideogram and the chromosome 
 labels. It is also possible to specify the genome and a list with the chromosomes to
 be plotted. 
 
 The \code{plot.type} parameter specifies the type of karyoplot to create: the number
 and positions of the data panels respect to the ideograms: 
 \itemize{
   \item \code{plot.type=1}  Horizontal ideograms with a single data panel above them
   \item \code{plot.type=2}  Horizontal ideograms with two data panels, one above and one below them
   \item \code{plot.type=3}  Horizontal ideograms with all chromosomes in a single line with two data panels, one above and one below them
   \item \code{plot.type=4}  Horizontal ideograms with all chromosomes in a single line with one data panel above
   \item \code{plot.type=5}  Horizontal ideograms with all chromosomes in a single line with one data panel below them
   \item \code{plot.type=6}  Horizontal ideograms with NO data panels. Only plotting in the ideograms is possible.
   \item \code{plot.type=7}  Horizontal ideograms with all chromosomes in a single line with NO data panels. Only plotting in the ideograms is possible.
 }
 
There's more information at the \url{https://bernatgel.github.io/karyoploter_tutorial/}{karyoploteR tutorial}.
}
\examples{
 
 set.seed(1000)

rand.data <- createRandomRegions(genome="hg19", nregions=10000, length.mean=1, 
                                 length.sd=0, mask=NA, non.overlapping=TRUE)
mcols(rand.data) <- data.frame(y=rnorm(n=10000, mean = 0.5, sd=0.1))
 
#The simplest way, with all default parameters
kp <- plotKaryotype()
kpPoints(kp, rand.data, pch=".")

#Or we can plot only a few chromosomes, with 2 data panels
kp <- plotKaryotype(chromosomes = c("chr1", "chr2"), plot.type = 2)
kpDataBackground(kp, data.panel = 1, color = "lightgreen")
kpDataBackground(kp, data.panel = 2, color = "lightblue")
kpPoints(kp, rand.data, pch=".", data.panel = 1)
kpPoints(kp, rand.data, pch=".", data.panel = 2)


#Or we can use a different organism, 
kp <- plotKaryotype(genome = "mm10")
kp <- plotKaryotype(genome = "dm6")

# Or we can change the plotting parameters. In this case, to create a smaller ideogram
# and smaller data panel below it
plot.params <- getDefaultPlotParams(plot.type=2)
plot.params$ideogramheight <- 5
plot.params$data2height <- 50

kp <- plotKaryotype(chromosomes = c("chr1", "chr2"), plot.type = 2, plot.params = plot.params)
kpDataBackground(kp, data.panel = 1, color = "lightgreen")
kpDataBackground(kp, data.panel = 2, color = "lightblue")
kpPoints(kp, rand.data, pch=".", data.panel = 1)
kpPoints(kp, rand.data, pch=".", data.panel = 2)

#Or we can remove the cytobands, passing an empty GRanges object
kp <- plotKaryotype(cytobands = GRanges())

#Or remove the chromosome labels
kp <- plotKaryotype(labels.plotter = NULL)
kpPoints(kp, rand.data, pch=".")

#In addition, it's possible to use maggrittr piping to chain the plotting calls
library(magrittr)
kp <- plotKaryotype() \%>\%
   kpDataBackground(color = "lightgreen") \%>\%
   kpPoints(rand.data, pch=".")


}
\seealso{
\code{\link{getDefaultPlotParams}}, \code{\link{kpPoints}}
}
