% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genes.R
\name{makeGenesDataFromTxDb}
\alias{makeGenesDataFromTxDb}
\title{makeGenesDataFromTxDb}
\usage{
makeGenesDataFromTxDb(txdb, karyoplot=NULL, plot.transcripts=TRUE, plot.transcripts.structure=TRUE)
}
\arguments{
\item{txdb}{(a TxDb object) The transcript database object from which the data will be extracted.}

\item{karyoplot}{(karyoplot object) A valid karyoplot object created by a call to \code{\link{plotKaryotype}}. If present, genes data will be restricted to the visible region in the plot. If NULL, all genes will be included. (defaults to NULL)}

\item{plot.transcripts}{(boolean) TRUE if transcripts are needed in addition to the genes. (defaults to TRUE)}

\item{plot.transcripts.structure}{(boolean) TRUE if the coding and non-coding exons are needed in addition to the genes and transcripts. (defaults to TRUE)}
}
\value{
Returns a list with at least one element called \code{genes}, a 
\code{GRanges} with all genes overlapping karyoplot. If 
\code{plot.transcripts} is TRUE, the returned list will have 
a \code{transcript} element, a list of \code{GRanges} objects, one per gene
(named with the gene ids),
with the transcripts of that gene. If \code{plot.transcripts.structure} is
TRUE, two more elements are present: \code{coding.exons} and 
\code{non.coding.exons}, each a list with one element per trascript 
(named with the transcript id), and each element the coding or non-coding
exons of that transcript.
}
\description{
This is a utility function that transforms a TxDb object into a custom 
object valid as input for \code{\link{kpPlotGenes}}.
}
\details{
This function creates a valid data object for \code{\link{kpPlotGenes}} 
starting from a TxDb object. The resulting object will contain only the
genes and transcripts ovelapping the plot region of the given Karyoplot 
object.
}
\note{
\code{\link{kpPlotGenes}} accepts TxDb objects directly. This 
function is only expected to be used when the user want to manipulate the 
results somehow (i.e. removing some of the genes).
}
\examples{
 

library(TxDb.Hsapiens.UCSC.hg19.knownGene)

zoom <- toGRanges("chr17", 32.6e6, 33.2e6)
kp <- plotKaryotype(genome="hg19", zoom=zoom)

genes.data <- makeGenesDataFromTxDb(TxDb.Hsapiens.UCSC.hg19.knownGene, 
                 karyoplot=kp, plot.transcripts=TRUE, 
                 plot.transcripts.structure=TRUE)
  
}
\seealso{
\code{\link{kpPlotGenes}}
}
