% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpAddCytobandLabels.R
\name{kpAddCytobandLabels}
\alias{kpAddCytobandLabels}
\title{kpAddCytobandLabels}
\usage{
kpAddCytobandLabels(karyoplot, cex=0.5, force.all=FALSE, clipping=TRUE, ...)
}
\arguments{
\item{karyoplot}{(karyoplot object) A valid karyoplot object created by a call to \code{\link{plotKaryotype}}}

\item{cex}{(numeric) The cex parameter for the cytoband labels}

\item{force.all}{(boolean) If true, all cytoband labels are plotted, even if they do not fit into the cytobands (Defaults to FALSE)}

\item{clipping}{(boolean) Only used if zooming is active. If TRUE, the name will be not drawn out of the drawing are (i.e. in margins, etc) even if the data overflows the drawing area. If FALSE, the labels may overflow into the margins of the plot. (defaults to TRUE)}

\item{...}{Any other parameter to be passed to internal function calls. Specially useful for graphic parameters.}
}
\value{
Returns the original karyoplot object, unchanged.
}
\description{
Plots the base numbers along the chromosome ideograms
}
\details{
This function can be used to add labels idenfifying the cytobands. It gets the
labels from the cytobands information stored in the karyoplot object and it will
only plot the labels that fit inside the available space. This means than in some 
cases (such as when plotting a complete genome with default parameters) it is 
possible that no labels at all are added.
}
\examples{
  
kp <- plotKaryotype()
kpAddBaseNumbers(kp)
kpAddCytobandLabels(kp)

kp <- plotKaryotype(chromosomes="chr17")
kpAddBaseNumbers(kp, tick.dist=10000000, minor.tick.dist=1000000)
kpAddCytobandLabels(kp)

 
}
\seealso{
\code{\link{plotKaryotype}}
}
