% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpAddChromosomeSeparators.R
\name{kpAddChromosomeSeparators}
\alias{kpAddChromosomeSeparators}
\title{kpAddChromosomeSeparators}
\usage{
kpAddChromosomeSeparators(karyoplot, col="gray", lty=3, data.panel="all", ...)
}
\arguments{
\item{karyoplot}{a \code{karyoplot} object returned by a call to \code{plotKaryotype}}

\item{col}{(color) The color of the separator lines (defaults to "gray")}

\item{lty}{(integer) The line type of the separators (defaults to 3, dashed lines)}

\item{data.panel}{(data panel specification) For vertical lines, the span of the separator lines. Ignored for horizontal lines. (defaults to "all")}

\item{...}{any additional parameter to be passed to the text plotting. All R base graphics params are passed along.}
}
\value{
invisibly returns the given karyoplot object
}
\description{
Plots between the chromosomes
}
\details{
Depending on the plot type it will draw vertical lines (if all chromosomes
are in a one line (3,4,5,7)) or horizontal lines (1,2,6)

By default the lines will occupy the whole chromsome extent (data.panel="all") 
but using the \code{data.panel} parameter it can be tuned.
}
\examples{

kp <- plotKaryotype(plot.type=4)
kpAddChromosomeSeparators(kp)

kp <- plotKaryotype(plot.type=5, ideogram.plotter=NULL)
kpAddChromosomeSeparators(kp)

kp <- plotKaryotype(plot.type=2)
kpAddChromosomeSeparators(kp, col="red")

 
}
\seealso{
\code{\link{plotKaryotype}}
}
