% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDefaultPlotParams.R
\name{getDefaultPlotParams}
\alias{getDefaultPlotParams}
\title{getDefaultParameters}
\usage{
getDefaultPlotParams(plot.type)
}
\arguments{
\item{plot.type}{(integer) the required plot type. can be any valid plot type (see \code{\link{plotKaryotype}})}
}
\value{
A valid \code{plot.params} object with the default values for the plotting parameters and 
ready to be used in the \code{plotKaryotype}
}
\description{
Returns the default parameters for the given plot.type
}
\details{
Given a plot.type, this function returns a list suitable as a valid \code{plot.params} object.
 The user can then proceed to change the parameter values as needed and supply the modified 
 list to the plotKaryotype function.#'
}
\examples{

pp <- getDefaultPlotParams(plot.type=2)
pp

#Change the ideogramheight param to create thicker ideograms 
pp$ideogramheight <- 150

plotKaryotype(genome="hg19", plot.type=2, plot.params=pp) 

 
}
\seealso{
\code{\link{plotKaryotype}}
}
