% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color.R
\name{colByValue}
\alias{colByValue}
\title{colByValue}
\usage{
colByValue(value, colors, min=NULL, max=NULL)
}
\arguments{
\item{value}{A vector of numeric values}

\item{colors}{(color) The colors to built the color ramp. Refer to \code{\link[grDevices]{colorRamp}} for more details.}

\item{min}{(NULL or numeric) The min value used to normalize the values. If NULL, min(value) will be used. (defaults to NULL)}

\item{max}{(NULL or numeric) The max value used to normalize the values. If NULL, max(value) will be used. (defaults to NULL)}
}
\value{
A vector of colors
}
\description{
Given a set of values, return a color for each of them based on their numeric
value.
}
\details{
A color ramp (similar to a gradient) will be built using the colors in the 
`colors` parameter using \code{\link[grDevices]{colorRamp}}.
Values will be normalized to [0,1] using `min` and `max`
(if NULL, min(value) will be 0 and max(value) will be 1) and these values
will be used to determine the color. It uses
}
\note{
Alpha values (transparency) are also used in the color computation
(see examples)
}
\examples{

colByValue(c(0,0.25,0.5,0.75,1), colors=c("red", "green"))
colByValue(c(0,0.25,0.5,0.75,1), colors=c("#00000000", "#00000011"))

data <- toGRanges("chr1", c(1e6*1:245), c(1e6*1:245)+10)
data$y <- rnorm(n = length(data), mean = 0.5, sd = 0.15)

kp <- plotKaryotype(chromosomes="chr1")
kpPoints(kp, data=data, r0=0, r1=0.3)
kpPoints(kp, data=data, r0=0.35, r1=0.65, col=colByValue(data$y, colors=c("black", "green")) )
kpPoints(kp, data=data, r0=0.7, r1=1, col=colByValue(data$y, colors=c("black", "green"), min=0.4, max=0.6))

kp <- plotKaryotype(chromosomes="chr1")
kpPoints(kp, data=data, r0=0, r1=0.3, col=colByValue(data$y, colors=c("#00000000", "#000000FF")))
kpPoints(kp, data=data, r0=0.35, r1=0.65, col=colByValue(data$y, colors=c("black", "orange", "green")) )
kpPoints(kp, data=data, r0=0.7, r1=1, col=colByValue(data$y, colors=c("red", "#00000022","#00000022", "green"),min=0.4, max=0.6))

}
\seealso{
\link{kpPoints}, \link{colByChr}
}
