% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color.R
\name{colByRegion}
\alias{colByRegion}
\title{colByRegion}
\usage{
colByRegion(data, regions, colors=NULL, original.colors=NULL, default.col="black")
}
\arguments{
\item{data}{Either a vector of characters or a GRanges object}

\item{regions}{(GRanges or equivalent) A set of regions where the color will be modified. Internally it will be converted into a Genomic Ranges object by \code{\link[regioneR]{toGRanges}} (from regioneR package) and so it can be either a GRanges, a data.frame, a character or any other value type accepted by that function. If \code{colors} is NULL (the default) and regions has additional columns in addition to chr, start and end, if any has a name in c("color", "colors", "col", "cols") it will be used. Otherwise the first additional column will be used.}

\item{colors}{(color) The colors to be used for each region. The content will be recycled if needed. If NULL, the colors are assumed to be available in the regions object. (defaults to NULL)}

\item{original.colors}{(color vector) The original colors of the data points. They will be use instead of the default color for data points not overlapping the regions. If NULL, the default color will be used. (defaults to NULL)}

\item{default.col}{The default color to return for data elements not overlapping the regions. Only used if original.colors is NULL (defaults to "black")}
}
\value{
A vector of colors
}
\description{
Given a set of data elements, return a color for each one based on whether 
they overlap a given set of regions. This might be useful, for example,  to
set a different color for data points overlapping a certain region of
interest.
}
\details{
Given a set of data elements, return a color for each one based on whether 
they overlap a given set of regions. The colors might be different for each
region and can be specified either in the regions object itself or in 
a separate \code{colors} parameter. If specified in \code{colors}, the values
will be recycled as needed. Data points not in the specified region can
take either a default color or keep their "original.color" if given. This
is useful when using colByRegion to highlight data points as in 
kpPlotManhattan.
}
\examples{

data <- toGRanges("chr1", c(1e6*1:245), c(1e6*1:245)+10)
data$y <- rnorm(n = length(data), mean = 0.5, sd = 0.15)

regions <- toGRanges(c("chr1:10e6-20e6", "chr1:100e6-150e6"))
regions$col <- c("red", "blue")

kp <- plotKaryotype(chromosomes="chr1")
kpPoints(kp, data=data, r0=0, r1=0.2)
kpPoints(kp, data=data, r0=0.2, r1=0.4, col=colByRegion(data, regions = regions) )
kpText(kp, data=data, r0=0.4, r1=0.6, col=colByRegion(data, regions = regions), label="A", cex=0.5 )
kpBars(kp, data=data, y0=0, y1=data$y, r0=0.6, r1=0.8, border=colByRegion(data, regions = regions))
#It might not work wor objects where R expects a single color such as lines. Segments should be used instead
kpLines(kp, data=data, r0=0.8, r1=1, col=colByRegion(data, regions = regions) )


kp <- plotKaryotype(chromosomes="chr1")
kpPoints(kp, data=data, r0=0, r1=0.25)
kpPoints(kp, data=data, r0=0.25, r1=0.5, col=colByRegion(data, regions = regions, colors="green") )
kpText(kp, data=data, r0=0.5, r1=0.75, col=colByRegion(data, regions = regions, color=c("gray", "gold")), label="A", cex=0.5 )
kpBars(kp, data=data, y0=0, y1=data$y, r0=0.75, r1=1, border=colByRegion(data, regions = regions))

}
\seealso{
\link{kpPoints}, \link{colByChr}, \link[regioneR]{toGRanges}
}
