% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasso_markers.R
\name{.get_lasso_coef}
\alias{.get_lasso_coef}
\title{help function to get lasso coefficient for every cluster for a given model}
\usage{
.get_lasso_coef(
  i_gene,
  gene_mt,
  vec_cluster,
  cluster_names,
  n_fold = 10,
  n_samples,
  sample_names
)
}
\arguments{
\item{i_gene}{Name of the current gene}

\item{gene_mt}{A matrix contains the transcript count in each grid.
Each row refers to a grid, and each column refers to a gene. The column
names must be specified and refer to the genes. This can be the
output from the function \code{\link{get_vectors}}.}

\item{vec_cluster}{A matrix of the spatial vectors for clusters.}

\item{cluster_names}{A vector of strings giving the name of clusters}

\item{n_fold}{Optional. A positive number giving the number of folds used
for cross validation. This parameter will pass to 
\code{\link[glmnet]{cv.glmnet}} to calculate a penalty term for every gene.}

\item{n_samples}{A positive number giving the number samples}

\item{sample_names}{A vector specifying the names for the sample}
}
\value{
a list of two matrices with the following components
\item{\code{coef_df} }{ A matrix giving the lasso coefficient of
each cluster}
\item{\code{lambda.1se} }{the lambda.1se value of best fitted model }
}
\description{
help function to get lasso coefficient for every cluster for a given model
}
