% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_permp.R
\name{.compute_observation}
\alias{.compute_observation}
\title{Compute observation statistic for permutation framework}
\usage{
.compute_observation(
  x,
  cluster_info,
  correlation_method,
  n_cores,
  test_genes,
  bin_type,
  bin_param,
  use_cm
)
}
\arguments{
\item{x}{a named list (of transcript detection coordinates) or 
SingleCellExperiment or SpatialExperiment or 
SpatialFeatureExperiment object. If a named list is provided, every list
element is a dataframe containing the transcript detection
coordinates and column names must include "feature_name" (gene name), 
"x" (x coordinate), "y" (y coordinate). 
The list names must match samples in cluster_info.}

\item{cluster_info}{A dataframe/matrix containing the centroid coordinates,
cluster label and sample for each cell.The column names must include
"x" (x coordinate), "y" (y coordinate),
"cluster" (cluster label) and "sample" (sample). It is strongly recommended 
to use syntactically valid names for columns clusters and samples. 
If invalid names are detected, the function \code{\link{make.names}} will be 
employed to generate valid names. A message will also be displayed to 
indicate this change.}

\item{correlation_method}{A parameter pass to \code{\link{cor}},
indicating which correlation coefficient is to be computed.
One of "pearson" (default), "kendall", or "spearman": can be abbreviated.}

\item{n_cores}{A positive number specifying number of cores used for
parallelizing permutation testing. Default is one core
(sequential processing).}

\item{test_genes}{A vector of strings giving the name of the genes you 
want to test correlation for.}

\item{bin_type}{A string indicating which bin shape is to be used for
vectorization. One of "square" (default), "rectangle", or "hexagon".}

\item{bin_param}{A numeric vector indicating the size of the bin. If the
\code{bin_type} is "square" or "rectangle", this will be a vector of length
two giving the numbers of rectangular quadrats in the x and y directions. If
the \code{bin_type} is "hexagonal", this will be a number giving the side
length of hexagons. Positive numbers only.}

\item{use_cm}{A boolean value that specifies whether to create spatial 
vectors for genes using the count matrix and cell coordinates instead of 
the transcript coordinates when both types of information are available. 
The default setting is FALSE.}
}
\value{
A named list with the following components
\item{\code{obs.stat}  }{ A matrix contains the observation statistic for
every gene and every cluster. Each row refers to a gene, and each column
refers to a cluster}
\item{\code{gene_mt}  }{ contains the transcript count in each grid.
Each row refers to a grid, and each column refers to a gene.}
}
\description{
Compute observation statistic for permutation framework
}
