% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isomiRs.R
\name{isoPlotPosition}
\alias{isoPlotPosition}
\title{Plot nucleotides changes at a given position}
\usage{
isoPlotPosition(ids, position = 1L, column = NULL)
}
\arguments{
\item{ids}{Object of class \link{IsomirDataSeq}.}

\item{position}{Integer indicating the position to show.}

\item{column}{String indicating the column in
colData to color samples.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} Object showing nucleotide changes
at a given position.
}
\description{
This function plot different isomiRs proportion for each sample at a given
position focused on the nucleotide change that happens there.
}
\details{
It shows the nucleotides changes at the given position for each
sample in each group.
The color indicates the sample group. The size of the point is proportional
to the number of total counts of isomiRs with changes.
The position at \code{y} is the \% of different isomiRs
supporting the change. Note the position is relatively to the
sequence not the miRNA.
}
\examples{
data(mirData)
isoPlotPosition(mirData)
}
