% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isomiRs.R
\name{isoCounts}
\alias{isoCounts}
\title{Create count matrix with different summarizing options}
\usage{
isoCounts(
  ids,
  ref = FALSE,
  iso5 = FALSE,
  iso3 = FALSE,
  add = FALSE,
  snv = FALSE,
  seed = FALSE,
  all = FALSE,
  minc = 1,
  mins = 1,
  merge_by = NULL
)
}
\arguments{
\item{ids}{Object of class \link{IsomirDataSeq}.}

\item{ref}{Differentiate reference miRNA from rest.}

\item{iso5}{Differentiate trimming at 5 miRNA from rest.}

\item{iso3}{Differentiate trimming at 3 miRNA from rest.}

\item{add}{Differentiate additions miRNA from rest.}

\item{snv}{Differentiate nt substitution miRNA from rest.}

\item{seed}{Differentiate changes in 2-7 nts from rest.}

\item{all}{Differentiate all isomiRs.}

\item{minc}{Int minimum number of isomiR sequences to be included.}

\item{mins}{Int minimum number of samples with number of
sequences bigger than \code{minc} counts.}

\item{merge_by}{Column in coldata to merge samples into a single
column in counts. Useful to combine technical replicates.}
}
\value{
\link{IsomirDataSeq} object with new count table.
The count matrix can be access with \code{counts(ids)}.
}
\description{
This function collapses isomiRs into different groups. It is a similar
concept than how to work with gene isoforms. With this function,
different changes can be put together into a single miRNA variant.
For instance all sequences with variants at 3' end can be
considered as different elements in the table
or analysis having the following naming
\verb{hsa-miR-124a-5p.iso.t3:AAA}.
}
\details{
You can merge all isomiRs into miRNAs by calling the function only
with the first parameter \code{isoCounts(ids)}.
You can get a table with isomiRs altogether and
the reference miRBase sequences by calling the function with \code{ref=TRUE}.
You can get a table with 5' trimming isomiRS, miRBase reference and
the rest by calling with \code{isoCounts(ids, ref=TRUE, iso5=TRUE)}.
If you set up all parameters to TRUE, you will get a table for
each different sequence mapping to a miRNA (i.e. all isomiRs).

Examples for the naming used for the isomiRs are at
http://seqcluster.readthedocs.org/mirna_annotation.html#mirna-annotation.
}
\examples{
data(mirData)
ids <- isoCounts(mirData, ref=TRUE)
head(counts(ids))
# taking into account isomiRs and reference sequence.
ids <- isoCounts(mirData, ref=TRUE, minc=10, mins=6)
head(counts(ids))
}
