% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_mat.R
\name{make_mat}
\alias{make_mat}
\alias{make_mat_se}
\alias{make_mat_gr}
\title{Make a matrix from a numeric column of BED files}
\usage{
make_mat(
  bedfiles,
  regions,
  column,
  mat_name = "value",
  sparse = FALSE,
  prealloc = 10000,
  nthreads = NULL
)

make_mat_se(
  bedfiles,
  regions,
  column,
  mat_name = "value",
  sparse = FALSE,
  prealloc = 10000,
  nthreads = NULL
)

make_mat_gr(
  bedfiles,
  regions,
  column,
  mat_name = "value",
  prealloc = 10000,
  nthreads = NULL
)
}
\arguments{
\item{bedfiles}{A vector of BED file paths}

\item{regions}{A vector, data frame or GenomicRanges of genomic regions. See details.}

\item{column}{The index of the data column needed for the matrix}

\item{mat_name}{What to name the matrix in the returned object}

\item{sparse}{Whether to return a sparse matrix}

\item{prealloc}{The number of rows to initialize the matrices with. If the
number of loci are approximately known, this can reduce runtime as fewer
resizes need to be made.}

\item{nthreads}{Set the number of threads to use. Overrides the
\code{"iscream.threads"} option. See \code{?set_threads} for more information.}
}
\value{
\itemize{
\item \code{make_mat()}: A named list of
\itemize{
\item the matrix with the value of interest
\item a character vector of chromosomes and numeric vector of base positions
\item a character vector of the input sample BED file names
}
\item \code{make_mat_gr()}: if \code{GenomicRanges} is available, a \code{GRanges}
\item \code{make_mat_se()}: if \code{SummarizedExperiment} is available, a \code{RangedSummarizedExperiment}
}
}
\description{
Queries the provided regions and produces a matrix along with genomic
positions as a named list (\code{make_mat()}), a \code{RangedSummarizedExperiment}
(\code{make_mat_se()}), \code{GRanges} (\code{make_mat_gr()}). Parallelized across files
using threads from the \code{"iscream.threads"} option.
}
\details{
The input regions may be string vector in the form "chr:start-end"
or a GRanges object. If a data frame is provided, they must have "chr",
"start", and "end" columns.
}
\examples{
bedfiles <- system.file("extdata", package = "iscream") |>
  list.files(pattern = "[a|b|c|d].bed.gz$", full.names = TRUE)
# examine the bedfiles
colnames <- c("chr", "start", "end", "beta", "coverage")
lapply(bedfiles, function(i) knitr::kable(read.table(i, col.names = colnames)))

# make a vector of regions
regions <- c("chr1:1-6", "chr1:7-10", "chr1:11-14")
# make matrix of beta values
make_mat(bedfiles, regions, column = 4)
}
