% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipdDbClass.R
\docType{methods}
\name{getReference,IpdDb-method}
\alias{getReference,IpdDb-method}
\alias{getReference}
\title{Get reference sequences}
\usage{
getReference(x, allele)
}
\arguments{
\item{x}{The database connection; an \code{\link{IpdDb}} object.}

\item{allele}{The alleles of interest as a character vector.}
}
\value{
A \code{\link[Biostrings:XStringSet-class]{Biostrings:DNAStringSet}}
object with all references.
}
\description{
Get the reference sequences for alleles.
}
\examples{
## Load the database 
hla <- loadHlaData()
## Get the loci
loci <- getLoci(hla)
## Get alleles of a locus
alleles <- getAlleles(hla, loci[1])
allelesOfInterest <- alleles[1:10]
## Get the sequences
seqs <- getReference(hla, allelesOfInterest)

}
