% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MACUI_interface.R
\name{decode_MAC}
\alias{decode_MAC}
\title{Decode MAC}
\usage{
decode_MAC(MAC)
}
\arguments{
\item{MAC}{multiple allele code (e.g. "A*01:ATJNV")}
}
\value{
list of HLA alleles
}
\description{
Decode a multiple allele code (MAC) into a list of HLA alleles.
#' The National Marrow Donor Program (NMDP) uses 
[MAC](https://bioinformatics.bethematchclinical.org/
hla-resources/allele-codes/allele-code-lists/) 
to facilitate the reporting and comparison of HLA alleles. MAC represent 
groups of HLA alleles and are useful when the 
HLA typing is ambiguous and does not allow to narrow down one single allele 
from a list of alleles.
}
\examples{
MAC <- "A*01:ATJNV"
decode_MAC(MAC)

}
